"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApplicationVersionBuildRequestFixturesFactories = exports.createApplicationVersionBuildRequest = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../../Lib/Fixtures/fixturesFactories");
function createApplicationVersionBuildRequest({ customFields, customApplicationFields, customBundledAppletFields, }) {
    return Object.assign({ requestUid: faker_1.faker.datatype.uuid(), application: Object.assign({ version: faker_1.faker.datatype.string(), name: faker_1.faker.datatype.string(), signature: faker_1.faker.datatype.string(), flavour: faker_1.faker.datatype.string() }, customApplicationFields), bundledApplet: Object.assign({ uid: faker_1.faker.datatype.uuid(), version: faker_1.faker.datatype.string(), name: faker_1.faker.datatype.string(), updatedAt: faker_1.faker.date.past(), publishedSince: faker_1.faker.date.past(), organizationUid: faker_1.faker.datatype.uuid(), organizationName: faker_1.faker.datatype.string(), entryFile: faker_1.faker.datatype.string(), baseUrl: faker_1.faker.datatype.string(), files: [], config: null }, customBundledAppletFields), bundledFrontApplet: {
            version: faker_1.faker.datatype.string(),
            binaryFileUrl: faker_1.faker.datatype.string(),
        }, autoVerification: {
            organizationUid: faker_1.faker.datatype.uuid(),
        }, createdAt: faker_1.faker.date.past(), failedAt: null, builtSince: faker_1.faker.date.past(), buildUrl: faker_1.faker.internet.url(), directBuildUrl: faker_1.faker.internet.url() }, customFields);
}
exports.createApplicationVersionBuildRequest = createApplicationVersionBuildRequest;
function createApplicationVersionBuildRequestFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.ApplicationVersionBuildRequest,
        createEntity: createApplicationVersionBuildRequest,
    });
}
exports.createApplicationVersionBuildRequestFixturesFactories = createApplicationVersionBuildRequestFixturesFactories;
//# sourceMappingURL=applicationVersionBuildRequestFixtures.js.map