import { IApplet } from '../../Schema/Applet/appletModel';
import { IAppletVersion } from '../../Schema/Applet/Version/appletVersionModel';
export declare type CustomFields = Partial<Omit<IAppletVersion, 'appletUid'>>;
export interface CreateProps {
    customFields?: CustomFields;
    applet: IApplet;
}
export declare function createAppletVersion({ applet, customFields }: CreateProps): IAppletVersion;
export declare function createAppletVersionFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IAppletVersion, Partial<Omit<IAppletVersion, "appletUid">>, CreateProps & {
        customFields?: Partial<Omit<IAppletVersion, "appletUid">> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IAppletVersion, Partial<Omit<IAppletVersion, "appletUid">>, CreateProps & {
        customFields?: Partial<Omit<IAppletVersion, "appletUid">> | undefined;
    }>;
};
//# sourceMappingURL=appletVersionFixtures.d.ts.map