import { IApplet } from '../../Schema/Applet/appletModel';
import { IOrganization } from '../../Schema/Organization/organizationModel';
export declare type CustomFields = Partial<IApplet>;
export interface CreateProps {
    customFields?: CustomFields;
    organization: IOrganization;
}
export declare function createApplet({ organization, customFields }: CreateProps): IApplet;
export declare function createAppletFixturesFactories(): {
    createSimpleFactory(): import("../../Lib/Fixtures/fixturesFactory").IFixturesFactory<IApplet, Partial<IApplet>, CreateProps & {
        customFields?: Partial<IApplet> | undefined;
    }>;
    createMongoFactory(mongodbConnection: import("@signageos/lib/dist/MongoDB/mongoDBConnectionFactory").IMongodbConnection): import("../../Lib/Fixtures/persistentFixturesFactory").IPersistentFixturesFactory<IApplet, Partial<IApplet>, CreateProps & {
        customFields?: Partial<IApplet> | undefined;
    }>;
};
//# sourceMappingURL=appletFixtures.d.ts.map