"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAlertFixturesFactories = exports.createAlert = void 0;
const faker_1 = require("@faker-js/faker");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const collections_1 = require("../../Mongo/Lib/collections");
function createAlert({ organization, alertRule, devices, customFields }) {
    var _a, _b, _c, _d, _e, _f;
    return Object.assign({ organizationUid: organization.uid, alertUid: faker_1.default.datatype.uuid(), alertRuleUid: alertRule.alertRuleUid, description: faker_1.default.hacker.noun(), createdAt: (_a = customFields === null || customFields === void 0 ? void 0 : customFields.createdAt) !== null && _a !== void 0 ? _a : new Date(), latelyChangedAt: (_b = customFields === null || customFields === void 0 ? void 0 : customFields.latelyChangedAt) !== null && _b !== void 0 ? _b : new Date(), latelyProcessedAt: (_c = customFields === null || customFields === void 0 ? void 0 : customFields.latelyChangedAt) !== null && _c !== void 0 ? _c : new Date(), archivedAt: (_d = customFields === null || customFields === void 0 ? void 0 : customFields.archivedAt) !== null && _d !== void 0 ? _d : null, deviceIdentityHashes: devices ? devices.map((device) => device.identityHash) : [], snoozeRule: (_e = customFields === null || customFields === void 0 ? void 0 : customFields.snoozeRule) !== null && _e !== void 0 ? _e : null, history: (_f = customFields === null || customFields === void 0 ? void 0 : customFields.history) !== null && _f !== void 0 ? _f : [] }, customFields);
}
exports.createAlert = createAlert;
function createAlertFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.Alert,
        createEntity: createAlert,
    });
}
exports.createAlertFixturesFactories = createAlertFixturesFactories;
//# sourceMappingURL=alertFixtures.js.map