"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAccountFixturesFactories = exports.createAccount = void 0;
const faker_1 = require("@faker-js/faker");
const collections_1 = require("../../Mongo/Lib/collections");
const fixturesFactories_1 = require("../../Lib/Fixtures/fixturesFactories");
const Account_1 = require("@signageos/common-types/dist/Account/Account");
function createAccount({ customFields }) {
    return Object.assign({ id: faker_1.faker.datatype.number(), username: faker_1.faker.internet.userName(), email: faker_1.faker.internet.email(), firstname: faker_1.faker.name.firstName(), lastname: faker_1.faker.name.lastName(), accessLevel: Account_1.AccessLevel.Platform, createdAt: faker_1.faker.date.past(), sessions: [], salt: faker_1.faker.random.alphaNumeric(20), isActive: true, privileges: [] }, customFields);
}
exports.createAccount = createAccount;
function createAccountFixturesFactories() {
    return (0, fixturesFactories_1.createFixturesFactories)({
        mongodbCollection: collections_1.Collection.Account,
        createEntity: createAccount,
    });
}
exports.createAccountFixturesFactories = createAccountFixturesFactories;
//# sourceMappingURL=accountFixtures.js.map