"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedisCache = void 0;
const helper_1 = require("../../Redis/helper");
class RedisCache {
    constructor(conn, keyPrefix) {
        this.conn = conn;
        this.keyPrefix = keyPrefix;
        // do nothing
    }
    get(key) {
        return __awaiter(this, void 0, void 0, function* () {
            const fullKey = this.getKey(key);
            return yield (0, helper_1.getOne)(this.conn, fullKey);
        });
    }
    set(key, value) {
        return __awaiter(this, void 0, void 0, function* () {
            const fullKey = this.getKey(key);
            yield (0, helper_1.createOne)(this.conn, fullKey, value);
        });
    }
    delete(key) {
        return __awaiter(this, void 0, void 0, function* () {
            const fullKey = this.getKey(key);
            yield (0, helper_1.deleteOne)(this.conn, fullKey);
        });
    }
    getKey(key) {
        return this.keyPrefix + '.' + key;
    }
}
exports.RedisCache = RedisCache;
//# sourceMappingURL=RedisCache.js.map