"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceModel = void 0;
const cacheFacade_1 = require("../../cacheFacade");
const object_1 = require("../../../Lib/object");
const createDeviceModel = (baseModel, cache) => {
    const wrapUpdateMethod = (updateMethod) => {
        return ((deviceRow, ...args) => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield updateMethod(deviceRow, ...args);
            yield cache.delete(getUidKey(deviceRow.uid));
            yield cache.delete(getIdentityHashKey(deviceRow.identityHash));
            return result;
        }));
    };
    return Object.assign(Object.assign({}, (0, object_1.pick)(baseModel, [
        'getDeviceIterator',
        'getListByOrganizationsIterator',
        'fetchListByAccount',
        'fetchListByIdentityHashes',
        'fetchListByOrganizations',
        'countByOrganizations',
        'countMapOfOrganizations',
        'countMapOfApplicationTypes',
        'countMapOfLocations',
        'fetchCountMapByProperty',
        'fetchIdentityHashesByOrganizations',
        'fetchGroupedIdentificationsByOrganizations',
        'fetchListByPropertyFilter',
        'fetchUidListByPropertyFilter',
        'fetchUidListByOrganizationUids',
        'countByPropertyFilter',
        'fetchModelsByOrganizations',
        'fetchApplicationTypesByOrganizations',
        'fetchAllFirmwareTypes',
        'fetchFirmwareVersionsByOrganizations',
        'fetchDeprovisionedSince',
        'getDeprovisionedCountByOrganizations',
        'fetchDevicesDistributionByDevicePlan',
        'fetchOrganizationDistributionByDevicePlan',
        'fetchOrganizationsDistributionByDevicePlan',
        'fetchListByCompanyUids',
        'fetchByPolicy',
        'countByPolicy',
        'countByPolicyAndApplicationType',
        'fetchOrganizationsUidsDevicesBelongTo',
        'fetchTags',
        'fetchOsVersionsByOrganizations',
        'fetchBrandsByOrganizations',
        'fetchCreatedBetween',
        'fetchListOfLocationUidsByDeviceIdentityHashes',
        'create',
    ])), { fetchByUid(uid) {
            return __awaiter(this, void 0, void 0, function* () {
                const key = getUidKey(uid);
                return yield (0, cacheFacade_1.getOneOrHandleMiss)(cache, key, () => __awaiter(this, void 0, void 0, function* () {
                    return yield baseModel.fetchByUid(uid);
                }));
            });
        },
        fetchByIdentityHash(identityHash) {
            return __awaiter(this, void 0, void 0, function* () {
                const key = getIdentityHashKey(identityHash);
                return yield (0, cacheFacade_1.getOneOrHandleMiss)(cache, key, () => __awaiter(this, void 0, void 0, function* () {
                    return yield baseModel.fetchByIdentityHash(identityHash);
                }));
            });
        }, updateModel: wrapUpdateMethod(baseModel.updateModel.bind(baseModel)), updateSerialNumber: wrapUpdateMethod(baseModel.updateSerialNumber.bind(baseModel)), updateBrand: wrapUpdateMethod(baseModel.updateBrand.bind(baseModel)), updateOSVersion: wrapUpdateMethod(baseModel.updateOSVersion.bind(baseModel)), updateName: wrapUpdateMethod(baseModel.updateName.bind(baseModel)), updateExtendedManagementSince: wrapUpdateMethod(baseModel.updateExtendedManagementSince.bind(baseModel)), updateExtendedManagementPairCode: wrapUpdateMethod(baseModel.updateExtendedManagementPairCode.bind(baseModel)), updateOrganization: wrapUpdateMethod(baseModel.updateOrganization.bind(baseModel)), removeOrganization: wrapUpdateMethod(baseModel.removeOrganization.bind(baseModel)), markBanned: wrapUpdateMethod(baseModel.markBanned.bind(baseModel)), markApproved: wrapUpdateMethod(baseModel.markApproved.bind(baseModel)), changeSubscriptionType: wrapUpdateMethod(baseModel.changeSubscriptionType.bind(baseModel)), updateAccount: wrapUpdateMethod(baseModel.updateAccount.bind(baseModel)), removeAccount: wrapUpdateMethod(baseModel.removeAccount.bind(baseModel)), updatePinCode: wrapUpdateMethod(baseModel.updatePinCode.bind(baseModel)), updateFirmwareType: wrapUpdateMethod(baseModel.updateFirmwareType.bind(baseModel)), updateFirmwareVersion: wrapUpdateMethod(baseModel.updateFirmwareVersion.bind(baseModel)), assignTag: wrapUpdateMethod(baseModel.assignTag.bind(baseModel)), removeTag: wrapUpdateMethod(baseModel.removeTag.bind(baseModel)), assignOrUpdatePolicy: wrapUpdateMethod(baseModel.assignOrUpdatePolicy.bind(baseModel)), removePolicy: wrapUpdateMethod(baseModel.removePolicy.bind(baseModel)), setLastProvisionedAt: wrapUpdateMethod(baseModel.setLastProvisionedAt.bind(baseModel)), setLastDeprovisionedAt: wrapUpdateMethod(baseModel.setLastDeprovisionedAt.bind(baseModel)), setFirstProvisionedAt: wrapUpdateMethod(baseModel.setFirstProvisionedAt.bind(baseModel)), assignDeviceToLocation: wrapUpdateMethod(baseModel.assignDeviceToLocation.bind(baseModel)), unassignDeviceFromLocation: wrapUpdateMethod(baseModel.unassignDeviceFromLocation.bind(baseModel)) });
};
exports.createDeviceModel = createDeviceModel;
function getUidKey(uid) {
    return 'uid.' + uid;
}
function getIdentityHashKey(identityHash) {
    return 'identityHash.' + identityHash;
}
//# sourceMappingURL=deviceModel.js.map