import { ICommandDispatcher } from '../Lib/CQRS/commandDispatcher';
import { ICommandOptions } from '../Lib/CQRS/commandFactory';
import * as accountCommands from '@signageos/commands/dist/Account/accountCommands';
import * as accountSettingsCommands from '@signageos/commands/dist/Account/accountSettingsCommands';
import * as accountSessionCommands from '@signageos/commands/dist/Account/Session/accountSessionCommands';
import * as alertCommands from '@signageos/commands/dist/Alert/alertCommands';
import * as appletVersionCommands from '@signageos/commands/dist/Applet/Version/appletVersionCommands';
import * as applicationVersionBuildCommands from '@signageos/commands/dist/Application/Version/applicationVersionBuildCommands';
import * as applicationVersionCommands from '@signageos/commands/dist/Application/Version/applicationVersionCommands';
import * as companyNetworkCommands from '@signageos/commands/dist/CompanyNetwork/companyNetworkCommands';
import * as deviceAutoRecoveryCommands from '@signageos/commands/dist/Device/AutoRecovery/deviceAutoRecoveryCommands';
import * as deviceConfigurationTelemetryCommands from '@signageos/commands/dist/Device/Configuration/deviceConfigurationTelemetryCommands';
import * as deviceCommands from '@signageos/commands/dist/Device/deviceCommands';
import * as deviceExtendedManagementCommands from '@signageos/commands/dist/Device/deviceExtendedManagementCommands';
import * as deviceInputSourceCommands from '@signageos/commands/dist/Device/InputSource/deviceInputSourceCommands';
import * as devicePackageCommands from '@signageos/commands/dist/Device/Package/devicePackageCommands';
import * as devicePeerRecoveryCommands from '@signageos/commands/dist/Device/PeerRecovery/devicePeerRecoveryCommands';
import * as devicePowerActionCommands from '@signageos/commands/dist/Device/Power/devicePowerActionCommands';
import * as deviceProvisioningRecipeCommands from '@signageos/commands/dist/Device/ProvisioningRecipe/deviceProvisioningRecipeCommands';
import * as deviceTelemetryExtendedCommands from '@signageos/commands/dist/Device/Telemetry/deviceExtendedTelemetryCommands';
import * as deviceVerificationCommands from '@signageos/commands/dist/Device/Verification/deviceVerificationCommands';
import * as deviceVPNCommands from '@signageos/commands/dist/Device/VPN/deviceVPNCommands';
import * as locationCommands from '@signageos/commands/dist/Location/locationCommands';
import * as organizationCompanyCommands from '@signageos/commands/dist/Organization/companyCommands';
import * as organizationCompanyNetworkCommands from '@signageos/commands/dist/Organization/CompanyNetwork/companyNetworkCommands';
import * as organizationCommands from '@signageos/commands/dist/Organization/organizationCommands';
import * as organizationTagCommands from '@signageos/commands/dist/Organization/Tag/organizationTagCommands';
import * as packageVersionCommands from '@signageos/commands/dist/Package/packageVersionCommands';
import * as policyCommands from '@signageos/commands/dist/Policy/policyCommands';
import * as termsCommands from '@signageos/commands/dist/Terms/termsCommands';
import * as termsAndConditionsCommands from '@signageos/commands/dist/TermsAndConditions/termsAndConditionsCommands';
import * as termsAndConditionsVersionCommands from '@signageos/commands/dist/TermsAndConditionsVersion/termsAndConditionsVersionCommands';
import * as thirdPartyCredentialsCommands from '@signageos/commands/dist/ThirdPartyCredentials/thirdPartyCredentialsCommands';
import * as timingCommands from '@signageos/commands/dist/Timing/timingCommands';
import * as uiThemeCommands from '@signageos/commands/dist/UITheme/uiThemeCommands';
import * as whiteLabelSettingsCommands from '@signageos/commands/dist/WhiteLabelSettings/whiteLabelSettingsCommands';
export declare function createCommandModels(commandDispatcher: ICommandDispatcher, commandOptions: ICommandOptions): {
    accountCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"Account", "Accounts", typeof accountCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    accountSettingsCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"", "List", typeof accountSettingsCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    accountSessionCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"AccountSession", "AccountSessions", typeof accountSessionCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    alertCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"Alert", "Alerts", typeof alertCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    appletVersionCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"AppletVersion", "AppletVersions", typeof appletVersionCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    applicationVersionBuildCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"ApplicationVersionBuild", "ApplicationVersionBuilds", typeof applicationVersionBuildCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    applicationVersionCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"ApplicationVersion", "ApplicationVersions", typeof applicationVersionCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    companyNetworkCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"CompanyNetwork", "CompanyNetworks", typeof companyNetworkCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    deviceAutoRecoveryCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"AutoRecovery", "AutoRecoveries", typeof deviceAutoRecoveryCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    deviceConfigurationTelemetryCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"DeviceConfigurationTelemetry", "DeviceConfigurationTelemetries", typeof deviceConfigurationTelemetryCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    deviceCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"Device", "Devices", typeof deviceCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    deviceExtendedManagementCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"ExtendedManagement", "ExtendedManagements", typeof deviceExtendedManagementCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    deviceInputSourceCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"InputSource", "InputSources", typeof deviceInputSourceCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    devicePackageCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"DevicePackage", "DevicePackages", typeof devicePackageCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    devicePeerRecoveryCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"PeerRecovery", "PeerRecoveries", typeof devicePeerRecoveryCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    devicePowerActionCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"PowerAction", "PowerActions", typeof devicePowerActionCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    deviceProvisioningRecipeCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"DeviceProvisioningRecipe", "DeviceProvisioningRecipes", typeof deviceProvisioningRecipeCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    deviceTelemetryExtendedCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"DeviceExtendedTelemetry", "DeviceExtendedTelemetries", typeof deviceTelemetryExtendedCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    deviceVerificationCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"DeviceVerification", "DeviceVerifications", typeof deviceVerificationCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    deviceVPNCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"DeviceVPN", "DeviceVPNS", typeof deviceVPNCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    locationCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"Location", "Locations", typeof locationCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    organizationCompanyCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"Company", "Companies", typeof organizationCompanyCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    organizationCompanyNetworkCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"CompanyNetwork", "CompanyNetworks", typeof organizationCompanyNetworkCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    organizationCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"Organization", "Organizations", typeof organizationCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    organizationTagCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"OrganizationTag", "OrganizationTags", typeof organizationTagCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    packageVersionCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"PackageVersion", "PackageVersions", typeof packageVersionCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    policyCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"Policy", "Policies", typeof policyCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    termsCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"Terms", "TermsList", typeof termsCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    termsAndConditionsCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"TermsAndConditions", "TermsAndConditionsList", typeof termsAndConditionsCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    termsAndConditionsVersionCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"TermsAndConditionsVersion", "TermsAndConditionsVersions", typeof termsAndConditionsVersionCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    thirdPartyCredentialsCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"ThirdPartyCredentials", "ThirdPartyCredentialsList", typeof thirdPartyCredentialsCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    timingCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"Timing", "Timings", typeof timingCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    uiThemeCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"UITheme", "UIThemes", typeof uiThemeCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
    whiteLabelSettingsCommandModel: import("../Lib/CQRS/commandModelFactory").CommandModel<"WhiteLabelSettings", "WhiteLabelSettingsList", typeof whiteLabelSettingsCommands, import("@signageos/lib/dist/AMQP/CQRS/ICommand").ICommandPayload<string>>;
};
//# sourceMappingURL=commandModelsFactory.d.ts.map