const fs = require('fs');

const packagePath = process.cwd() + '/package.json';
const packageLockPath = process.cwd() + '/package-lock.json';
const package = require(packagePath);
let packageLock;
try {
	packageLock = require(packageLockPath);
} catch (error) {
	// overlook if doesn't exist
}

const nextVersion = process.argv[2];
if (!nextVersion) {
	throw new Error('No version specified');
}
package.version = nextVersion;
if (packageLock) {
	packageLock.version = nextVersion;
	if (packageLock.packages && packageLock.packages['']) {
		packageLock.packages[''].version = nextVersion;
	}
}

fs.writeFileSync(packagePath, JSON.stringify(package, null, 2) + '\n');
if (packageLock) {
	fs.writeFileSync(packageLockPath, JSON.stringify(packageLock, null, 2) + '\n');
}
