const { getPipedInput, getGroupedChangeLog } = require('./helper');

const allChangeTypes = ['Changed', 'Removed', 'Added', 'Fixed', 'Security', 'Deprecated'];

(async function () {
	const changeLog = await getPipedInput();
	const groupedLog = getGroupedChangeLog(changeLog);
	const changedTypes = Object.keys(groupedLog.Unreleased || {});
	switch (true) {
		case changedTypes.indexOf('Changed') !== -1:
		case changedTypes.indexOf('Removed') !== -1:
			process.stdout.write('major');
			break;
		case changedTypes.indexOf('Added') !== -1:
			process.stdout.write('minor');
			break;
		case changedTypes.indexOf('Fixed') !== -1:
		case changedTypes.indexOf('Security') !== -1:
		case changedTypes.indexOf('Deprecated') !== -1:
			process.stdout.write('patch');
			break;
		case changedTypes.length === 0:
			process.stdout.write('patch');
			break;
		default:
			throw new Error(`Unknown type of change: ${changedTypes.join(', ')} Only following values are allowed: ${allChangeTypes.join(', ')}`);
	}
})();

process.on('unhandledRejection', (error) => {
	throw error;
});
