import ISocket, { UnconfirmedMessageError, UndeliveredEmitError, IErrorEvent } from '../ISocket';
import AutoReconnectingWSSocket from './AutoReconnectingWSSocket';
export interface IOptions {
    enablePingPong: boolean;
    pingPongTimeout: number;
}
export declare function createSocket(socketUri: string, onConnected: () => void, onDisconnected: () => void, onError: (error: IErrorEvent | UnconfirmedMessageError | UndeliveredEmitError) => void, options?: IOptions): ISocket;
export declare function createAutoReconnectingSocket(socketUri: string, onConnected: () => void, onDisconnected: () => void, onError: (error: IErrorEvent | UnconfirmedMessageError | UndeliveredEmitError) => void, options?: IOptions, initialReconnectTimeout?: number, maxReconnectTimeout?: number): AutoReconnectingWSSocket;
