"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const io = require("socket.io-client");
const url = require("url");
function createSocket(socketUri, onConnected, onDisconnected, onError) {
    const parsedSocketUrl = url.parse(socketUri);
    const pathname = parsedSocketUrl.pathname;
    const socketUrl = parsedSocketUrl.protocol + '//' + parsedSocketUrl.host;
    const socketIoPath = (pathname + '/socket.io').replace(/\/+/g, '/');
    const socket = io(socketUrl, {
        path: socketIoPath,
        forceNew: true,
        upgrade: false,
        rememberUpgrade: true,
        transports: ['websocket'],
        reconnection: false,
        timeout: 5e3,
    });
    socket.on('connect_error', (error) => onError(error));
    socket.on('error', (error) => onError(error));
    socket.on('connection', () => onConnected());
    socket.on('disconnect', () => onDisconnected());
    return {
        on(event, listener) {
            socket.on(event, (message, callback) => {
                listener(message);
                if (callback) {
                    callback();
                }
            });
        },
        once(event, listener) {
            socket.once(event, (message, callback) => {
                listener(message);
                if (callback) {
                    callback();
                }
            });
        },
        emit(event, message, callback) {
            socket.emit(event, message, callback);
        },
        removeListener(event, listener) {
            socket.off(event, listener);
        },
        removeAllListeners() {
            socket.removeAllListeners();
        },
        close() {
            socket.close();
        },
    };
}
exports.default = createSocket;
//# sourceMappingURL=createSocketIOSocket.js.map