import { ILegacyTimer, ILongWeekdayTimer, IShortWeekdayTimer } from './Power/PowerTimerSettings';
import TimerType from './Power/PowerTimerType';
export declare function convertLongWeekdayTimerSettingsToLegacyTimerSettings(settings: {
    [type: TimerType]: ILongWeekdayTimer;
}): Record<`TIMER_${number}`, {
    sun: boolean;
    mon: boolean;
    tue: boolean;
    wed: boolean;
    thu: boolean;
    fri: boolean;
    sat: boolean;
    type: `TIMER_${number}`;
    timeOn: string | null;
    timeOff: string | null;
}>;
export declare function convertShortWeekdayTimerSettingsToLegacyTimerSettings(settings: {
    [type: TimerType]: IShortWeekdayTimer;
}): Record<`TIMER_${number}`, {
    sun: boolean;
    mon: boolean;
    tue: boolean;
    wed: boolean;
    thu: boolean;
    fri: boolean;
    sat: boolean;
    type: `TIMER_${number}`;
    timeOn: string | null;
    timeOff: string | null;
}>;
export declare function convertLegacyTimerToShortWeekdayTimer(settings: {
    [type: TimerType]: ILegacyTimer;
}): Record<`TIMER_${number}`, {
    weekdays: import("./Power/PowerTimerWeekdayEnum").ShortWeekdayEnum[];
    type: `TIMER_${number}`;
    timeOn: string | null;
    timeOff: string | null;
}>;
export declare function convertTimersToLongWeekdayTimerSettings(shortWeekdayTimer: IShortWeekdayTimer[]): {
    [type: `TIMER_${number}`]: ILongWeekdayTimer;
};
export declare function convertTimersToShortWeekdayTimerSettings(shortWeekdayTimer: IShortWeekdayTimer[]): {
    [type: `TIMER_${number}`]: IShortWeekdayTimer;
};
