/// <reference types="node" />
import { Server as HttpServer } from 'http';
import { Application } from 'express';
import { IMetricsClient } from '../Metrics/MetricsClient';
export interface ServiceInfo {
    name: string;
    version: string;
}
export interface IHttpServer {
    /** Main HTTP server */
    server: HttpServer;
    /** Use this to extend application HTTP routes */
    express: Application;
    /** Monitoring runs on a separate port for security reasons */
    monitoringServer: HttpServer;
    /** Use this to extend monitoring HTTP routes */
    monitoringExpress: Application;
    listen(): Promise<void>;
    /**
     * Waits for the server to finish serving all requests, then closes it
     */
    close(): Promise<void>;
}
export interface IService {
    httpServer: IHttpServer;
    metricsClient: IMetricsClient;
    /**
     * Returns true if the service has been started
     */
    isStarted(): boolean;
    /**
     * Starts the service and all its sub-services, i.e.:
     *   - Sentry
     *   - HTTP server
     */
    start(): Promise<void>;
    /**
     * Stops the service and all the sub-services managed by it, i.e. the HTTP server
     *
     * It will block until HTTP server finishes serving all requests
     */
    stop(): Promise<void>;
}
