"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = void 0;
const sentry_1 = require("./sentry");
const process_1 = require("./process");
class Service {
    constructor(args) {
        this.started = false;
        this.httpServer = args.httpServer;
        this.metricsClient = args.metricsClient;
        this.serviceInfo = args.serviceInfo;
        this.sentry = args.sentry;
    }
    isStarted() {
        return this.started;
    }
    start() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.httpServer.listen();
            (0, sentry_1.initSentry)({ service: this.serviceInfo, options: this.sentry });
            (0, process_1.handleSignals)(this);
            (0, process_1.suppressUncaughtExceptions)();
            this.started = true;
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.httpServer.close();
            this.started = false;
        });
    }
}
exports.Service = Service;
//# sourceMappingURL=Service.js.map