"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createServer = void 0;
const http = require("http");
const Debug = require("debug");
const wait_1 = require("../../../Timer/wait");
const debug = Debug('@signageos/lib:Service:HTTP:server:serverFactory');
/**
 * Create a HTTP server from an Express app running on a given port
 */
function createServer(app, port) {
    const server = http.createServer(app);
    server.on('error', (error) => console.error(error));
    return {
        server,
        listen() {
            return new Promise((resolve) => {
                server.listen(port, () => resolve());
            });
        },
        close() {
            return __awaiter(this, void 0, void 0, function* () {
                yield drainHttpServerConnections(server);
                yield new Promise((resolve) => {
                    server.close(() => resolve());
                });
            });
        },
    };
}
exports.createServer = createServer;
/**
 * Wait for the server to finish serving all requests
 */
function drainHttpServerConnections(httpServer) {
    return __awaiter(this, void 0, void 0, function* () {
        while (true) {
            const connectionsCount = yield getHttpServerConnections(httpServer);
            if (connectionsCount <= 0) {
                break;
            }
            debug(`Waiting for ${connectionsCount} connections to drain`);
            yield (0, wait_1.default)(100);
        }
    });
}
function getHttpServerConnections(httpServer) {
    return new Promise((resolve, reject) => httpServer.getConnections((error, count) => (error ? reject(error) : resolve(count))));
}
//# sourceMappingURL=serverFactory.js.map