"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createExpressApp = void 0;
const express = require("express");
const qs = require("qs");
/**
 * Create an instance of an Express application and apply common middleware
 */
function createExpressApp() {
    const app = express();
    // Parses query string, converting comma separated values into arrays
    // should be defined before any other middleware due to known issue in versions before 5
    // see more: https://github.com/expressjs/express/issues/3454
    app.set('query parser', (rawQueryString) => {
        return qs.parse(rawQueryString, { comma: true });
    });
    return app;
}
exports.createExpressApp = createExpressApp;
//# sourceMappingURL=expressFactory.js.map