"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAppExpress = void 0;
const express = require("express");
const accessLogMiddleware_1 = require("../middleware/accessLogMiddleware");
const logging_1 = require("../../../Logging/logging");
const router_1 = require("../routes/app/router");
const expressFactory_1 = require("./expressFactory");
const accessLogLogger = logging_1.logger.createNamespace('accessLog');
function createAppExpress(args) {
    const { accessLogCallback } = args;
    const app = (0, expressFactory_1.createExpressApp)();
    // Log all requests
    app.use((0, accessLogMiddleware_1.accessLogMiddleware)((accessLog, req, res) => {
        accessLogLogger.info(`${accessLog.method} ${accessLog.path}`, Object.assign(Object.assign({}, accessLog), accessLogCallback === null || accessLogCallback === void 0 ? void 0 : accessLogCallback(accessLog, req, res)));
    }));
    const router = express.Router();
    (0, router_1.routeApp)(Object.assign(Object.assign({}, args), { router }));
    app.use('/', router);
    return app;
}
exports.createAppExpress = createAppExpress;
//# sourceMappingURL=app.js.map