"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.copyRecursively = void 0;
const path = require("path");
const Rsync = require("rsync");
const child_process_1 = require("child_process");
function copyRecursively(sourcePath, remoteDestinationPath, shell) {
    return __awaiter(this, void 0, void 0, function* () {
        const [destinationHost, destinationPath] = remoteDestinationPath.indexOf(':') !== -1 ? remoteDestinationPath.split(':') : [undefined, remoteDestinationPath];
        const ensureDirProcess = (0, child_process_1.spawn)(shell || 'sh', [
            ...(destinationHost ? [destinationHost] : []),
            'mkdir',
            '-p',
            path.dirname(destinationPath),
        ]);
        yield executeProcess(ensureDirProcess);
        const copyFileRsync = new Rsync().flags('pt').source(sourcePath).destination(remoteDestinationPath);
        if (shell) {
            copyFileRsync.shell(shell);
        }
        yield executeRsync(copyFileRsync);
    });
}
exports.copyRecursively = copyRecursively;
function executeRsync(rsync) {
    return new Promise((resolve, reject) => {
        rsync.execute((error) => {
            if (error) {
                reject(error);
            }
            else {
                resolve();
            }
        });
    });
}
function executeProcess(childProcess) {
    return new Promise((resolve, reject) => {
        childProcess.on('close', (_code) => resolve());
        childProcess.on('error', (error) => reject(error));
    });
}
//# sourceMappingURL=copier.js.map