"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timeoutable = void 0;
const wait_1 = require("../Timer/wait");
function timeoutable(fn, timeoutMs) {
    return Promise.race([fn(), (0, wait_1.default)(timeoutMs).then(() => Promise.reject(new Error(`Timeout has been reached after ${timeoutMs} ms`)))]);
}
exports.timeoutable = timeoutable;
//# sourceMappingURL=timeoutable.js.map