"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findFirstParentModulePath = exports.detectModuleRootPath = void 0;
const path = require("path");
/**
 * @deprecated use findFirstParentModulePath instead
 */
function detectModuleRootPath(moduleName, deepLimit = 10, basePath = __dirname) {
    let fs;
    try {
        fs = require('fs');
    }
    catch (error) {
        return null;
    }
    for (let i = 0; i < deepLimit; i++) {
        const packagePath = path.join(basePath, 'package.json');
        if (fs.existsSync(packagePath) && JSON.parse(fs.readFileSync(packagePath).toString()).name === moduleName) {
            return path.resolve(basePath);
        }
        const packageModulePath = path.join(basePath, moduleName, 'package.json');
        if (fs.existsSync(packageModulePath) && JSON.parse(fs.readFileSync(packageModulePath).toString()).name === moduleName) {
            return path.resolve(path.join(basePath, moduleName));
        }
        basePath = path.join(basePath, '..');
    }
    throw new Error('Root path was not found');
}
exports.detectModuleRootPath = detectModuleRootPath;
/**
 * Looks for package.json file in current working directory and parent directories.
 * Returns first path, where package.json was found.
 */
function findFirstParentModulePath(basePath = __dirname, deepLimit = 10) {
    let fs;
    try {
        fs = require('fs');
    }
    catch (error) {
        return null;
    }
    for (let i = 0; i < deepLimit; i++) {
        const packagePath = path.join(basePath, 'package.json');
        if (fs.existsSync(packagePath)) {
            return path.resolve(basePath);
        }
        basePath = path.join(basePath, '..');
    }
    throw new Error('Root path was not found');
}
exports.findFirstParentModulePath = findFirstParentModulePath;
//# sourceMappingURL=detector.js.map