"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmClient = void 0;
const child_process_1 = require("child_process");
const util_1 = require("util");
const path = require("path");
const AsyncLock = require("async-lock");
const fs = require("fs-extra");
const Debug = require("debug");
const debugDecorator_1 = require("../Debug/debugDecorator");
const NpmCredentialsProvider_1 = require("./NpmCredentialsProvider");
const DEBUG_NAMESPACE = '@signageos/lib:Npm:NpmClient';
const logDebug = Debug(DEBUG_NAMESPACE);
const execAsync = (0, util_1.promisify)(child_process_1.exec);
class NpmClient {
    constructor(credentialsProvider = (0, NpmCredentialsProvider_1.createDefaultNpmCredentialsProvider)()) {
        this.credentialsProvider = credentialsProvider;
        this.lock = new AsyncLock();
    }
    getPackageVersions(packageName) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = yield this.execNpmCommand({
                command: 'info',
                args: [packageName, 'versions', '--json'],
            });
            const resultParsed = JSON.parse(result);
            if (typeof resultParsed === 'string') {
                return [resultParsed];
            }
            else {
                return resultParsed;
            }
        });
    }
    downloadPackage({ packageName, downloadPath, version }) {
        return __awaiter(this, void 0, void 0, function* () {
            const lockKey = version ? `${packageName}.${version}` : packageName;
            return yield this.lock.acquire(lockKey, () => __awaiter(this, void 0, void 0, function* () {
                const packageWithVersion = version ? `${packageName}@${version}` : packageName;
                const fileName = yield this.execNpmCommand({
                    command: 'pack',
                    args: [packageWithVersion],
                });
                const srcPath = path.join(process.cwd(), fileName.trim());
                const destPath = path.join(downloadPath, fileName.trim());
                yield fs.move(srcPath, destPath);
                return destPath;
            }));
        });
    }
    execNpmCommand({ command, args }) {
        return __awaiter(this, void 0, void 0, function* () {
            const credentials = yield this.credentialsProvider();
            const argsString = args ? args.join(' ') : '';
            const fullCommand = `npm ${command} ${argsString}`;
            const { stdout, stderr } = yield execAsync(fullCommand, {
                env: {
                    PATH: process.env.PATH,
                    NPM_REGISTRY_HOST: credentials.host,
                    NPM_REGISTRY_URL: credentials.url,
                    NPM_AUTH_TOKEN: credentials.authToken,
                },
            });
            if (stdout) {
                logDebug(`exec command: ${fullCommand}`, stdout);
            }
            if (stderr) {
                logDebug(`exec command: ${fullCommand}`, stderr);
            }
            return stdout;
        });
    }
}
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], NpmClient.prototype, "getPackageVersions", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NpmClient.prototype, "downloadPackage", null);
exports.NpmClient = NpmClient;
//# sourceMappingURL=NpmClient.js.map