"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.doConnectionCallback = exports.withoutOptions = exports.getDsn = exports.tryConnection = void 0;
const _ = require("lodash");
const mongodb = require("mongodb");
const connection_string_parser_1 = require("connection-string-parser");
const Debug = require("debug");
const debug = Debug('@signageos/lib:MongoDB:proprietaryCluster');
const connectionStringParser = new connection_string_parser_1.ConnectionStringParser({
    scheme: 'mongodb',
    hosts: [],
});
function tryConnection(host, parameters) {
    return __awaiter(this, void 0, void 0, function* () {
        return doConnectionCallback(host, parameters, (connection) => __awaiter(this, void 0, void 0, function* () {
            return yield connection.db(parameters.endpoint).stats();
        }));
    });
}
exports.tryConnection = tryConnection;
function getDsn(host, parameters, omitParamNames = []) {
    return connectionStringParser.format(withoutOptions(Object.assign(Object.assign({}, parameters), { hosts: [host] }), omitParamNames));
}
exports.getDsn = getDsn;
function withoutOptions(parameters, omitParamNames = []) {
    return Object.assign(Object.assign({}, parameters), { options: _.omit(parameters.options, 'proprietaryServerSelectionStrategy', 'proprietaryReplicaSet', ...omitParamNames) });
}
exports.withoutOptions = withoutOptions;
function doConnectionCallback(host, parameters, callback) {
    return __awaiter(this, void 0, void 0, function* () {
        const dsn = getDsn(host, parameters);
        const connection = yield mongodb.MongoClient.connect(dsn, {
            connectTimeoutMS: 5e3,
            socketTimeoutMS: 5e3,
            serverSelectionTimeoutMS: 5e3, // in proprietary replica set, host should have 1 node, so this is not usually used
        });
        const result = yield callback(connection);
        debug('connection callback result', host, parameters, result);
        yield connection.close();
        return result;
    });
}
exports.doConnectionCallback = doConnectionCallback;
//# sourceMappingURL=helper.js.map