"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricsClient = void 0;
const prometheusClient = require("prom-client");
class MetricsClient {
    constructor(client = prometheusClient) {
        this.client = client;
    }
    getClient() {
        return this.client;
    }
    init() {
        this.client.collectDefaultMetrics();
    }
    serve(response) {
        return __awaiter(this, void 0, void 0, function* () {
            response.set('Content-Type', this.client.register.contentType);
            const responseBody = yield this.client.register.metrics();
            return response.send(responseBody);
        });
    }
    clear() {
        this.client.register.clear();
    }
}
exports.MetricsClient = MetricsClient;
//# sourceMappingURL=MetricsClient.js.map