"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendStatusResponse = void 0;
const time = require("../DateTime/dateTimeFactory");
const os = require("os");
const HttpStatus = require("http-status");
function sendStatusResponse(req, res, name, uid, timeout, statusRequestedAt, serviceGroupResponses, additionalDataCallback = () => undefined) {
    const serviceNames = Object.keys(serviceGroupResponses);
    const failedServices = serviceNames.filter((serviceName) => 'error' in serviceGroupResponses[serviceName]);
    const succeededServices = serviceNames.filter((serviceName) => 'response' in serviceGroupResponses[serviceName]);
    const success = failedServices.length === 0;
    const statusResponse = {
        name,
        status: success ? 'OK' : 'FAILED',
        process: {
            uid,
            pid: process.pid,
            version: process.version,
            uptime: process.uptime(),
            cpuUsage: process.cpuUsage(),
            memoryUsage: process.memoryUsage(),
        },
        hostname: os.hostname(),
        failedServices,
        succeededServices,
        timeout,
        requestedAt: statusRequestedAt.valueOf(),
        respondedAt: time.now().valueOf(),
    };
    const response = Object.assign(Object.assign(Object.assign({}, statusResponse), additionalDataCallback(req)), serviceGroupResponses);
    res.status(success ? HttpStatus.OK : HttpStatus.SERVICE_UNAVAILABLE).send(response);
}
exports.sendStatusResponse = sendStatusResponse;
//# sourceMappingURL=sendStatusResponse.js.map