"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const time = require("../DateTime/dateTimeFactory");
function enrichHttpServerWithStatus(httpServer) {
    let isHttpServerReady = false;
    return Object.assign(Object.assign({}, httpServer), { listen: () => {
            httpServer.listen();
            isHttpServerReady = true;
        }, close: () => {
            isHttpServerReady = false;
            httpServer.close();
        }, getConnections: () => {
            return new Promise((resolve, reject) => httpServer.http.getConnections((error, count) => (error ? reject(error) : resolve(count))));
        }, getStatus: () => () => __awaiter(this, void 0, void 0, function* () {
            const timeNow = time.now();
            const httpServerStatusResponse = isHttpServerReady
                ? {
                    response: {
                        requestedAt: timeNow.valueOf(),
                        respondedAt: timeNow.valueOf(),
                        responseTime: 0,
                    },
                }
                : {
                    error: {
                        message: 'Server was stopped',
                        requestedAt: timeNow.valueOf(),
                        failedAt: timeNow.valueOf(),
                        errorTime: 0,
                    },
                };
            return { httpServer: httpServerStatusResponse };
        }), setStatus: (isReady) => {
            isHttpServerReady = isReady;
        } });
}
exports.default = enrichHttpServerWithStatus;
//# sourceMappingURL=enrichHttpServerWithStatus.js.map