"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.downloadFile = void 0;
const fs = require("fs");
const util_1 = require("util");
const stream_1 = require("stream");
const node_fetch_1 = require("node-fetch");
const streamPipeline = (0, util_1.promisify)(stream_1.pipeline);
function downloadFile(srcUrl, destPath) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield (0, node_fetch_1.default)(srcUrl);
        if (!response.ok) {
            throw new Error('Unable to download file from ' + srcUrl + ': ' + response.statusText);
        }
        const destinationStream = fs.createWriteStream(destPath);
        yield streamPipeline(response.body, destinationStream);
    });
}
exports.downloadFile = downloadFile;
//# sourceMappingURL=download.js.map