"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateSalt = exports.generateUniqueHash = void 0;
const crypto_1 = require("crypto");
function generateUniqueHash(length = 50) {
    const hash = (0, crypto_1.createHash)('sha256');
    hash.update('' + new Date().valueOf() + Math.random());
    return hash.digest('hex').substring(0, length);
}
exports.generateUniqueHash = generateUniqueHash;
function generateSalt(length) {
    return (0, crypto_1.randomBytes)(length).toString('hex').substring(0, length);
}
exports.generateSalt = generateSalt;
//# sourceMappingURL=generator.js.map