"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.packDist = void 0;
const fs = require("fs-extra");
const path = require("path");
const child_process_1 = require("child_process");
const util = require("util");
const tmp = require("tmp");
const tar = require("tar");
const execPromise = util.promisify(child_process_1.exec);
const packDist = (options) => __awaiter(void 0, void 0, void 0, function* () {
    if (options.environment === 'dev') {
        const timestampNumber = new Date().toISOString().replace(/[^\d]/gi, '').substr(0, 14);
        const devVersion = (options.getVersion ? options.getVersion() : '99.0.0-dev') + '.' + timestampNumber;
        const tmpDir = tmp.dirSync().name;
        yield fs.copy(path.join(options.rootPath, 'dist'), path.join(tmpDir, 'package', 'dist'));
        yield fs.copy(path.join(options.rootPath, 'README.md'), path.join(tmpDir, 'package', 'README.md'));
        const configPath = path.join(options.rootPath, 'package.json');
        const configContents = yield fs.readJson(configPath);
        configContents.version = devVersion;
        yield fs.writeJson(path.join(tmpDir, 'package', 'package.json'), configContents, { spaces: 2 });
        const tarballDir = path.join(options.packagesPath, options.name, devVersion);
        const tarballFileName = options.name.replace(/^@/, '').replace(/\//g, '-') + '-' + devVersion + '.tgz';
        yield fs.ensureDir(tarballDir);
        yield tar.c({
            gzip: true,
            file: path.join(tarballDir, tarballFileName),
            cwd: tmpDir,
        }, ['package']);
        yield packDependencies(options);
        console.info('Tarball release ' + tarballFileName);
    }
});
exports.packDist = packDist;
function packDependencies(options) {
    return __awaiter(this, void 0, void 0, function* () {
        const configLockPath = path.join(options.rootPath, 'package-lock.json');
        const configLockContents = yield fs.readJson(configLockPath);
        const dependencies = options.dependencies || [];
        for (const dependency of dependencies) {
            const dependencyVersion = 'dependencies' in configLockContents
                ? // lockfileVersion 0 and 1
                    configLockContents.dependencies[dependency].version
                : // lockfileVersion 2 and 3
                    configLockContents.packages['node_modules/' + dependency].version;
            const dependencyVersionPath = path.join(options.packagesPath, dependency, dependencyVersion);
            if (!(yield fs.pathExists(dependencyVersionPath))) {
                const { stdout } = yield execPromise(`npm pack ${dependency}@${dependencyVersionPath}`);
                const fileName = stdout.trim();
                yield fs.ensureDir(dependencyVersionPath);
                yield fs.move(path.join(options.rootPath, fileName), path.join(dependencyVersionPath, fileName));
            }
        }
    });
}
//# sourceMappingURL=pack.js.map