"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHtml5TestScript = void 0;
const fs = require("fs");
const Bundler_1 = require("../Bundler");
const swc = require("@swc/core");
const loadWhichBrowser_1 = require("./loadWhichBrowser");
const getHtml5TestScript = () => __awaiter(void 0, void 0, void 0, function* () {
    const engine = yield fs.promises.readFile('./node_modules/html5test/scripts/9/engine.js').then((b) => b.toString());
    const script = `
    (function () {
      var resolve = window.__SOS_HTML5TEST_RESOLVE;
      delete window.__SOS_HTML5TEST_RESOLVE;

      if(typeof resolve === "function") {
        ${ /* This script can't run in strict mode, so this prevent undeclared variables to be assigned to window object */''}
        var f, Test, Test9, passed;

        ${loadWhichBrowser_1.loadWhichBrowser.toString()}
        ${engine}

        loadWhichBrowser(function () {
          ${ /* WhichBrowser is injected be external script so it need to stay on window */''}
          window.Browsers = new window.WhichBrowser({
            useFeatures: true,
            detectCamouflage: true,
          });

          new Test(function (result) {
            resolve(result);
          });
        });
      }
    })();
  `;
    // Minify code with swc, can't use esbuild, because it may choose to minify with ES5+ features
    // https://esbuild.github.io/faq/#minified-newlines
    const minified = yield swc.transform(script, { minify: false, jsc: { target: 'es5' } });
    return Bundler_1.Bundler.enc(minified.code);
});
exports.getHtml5TestScript = getHtml5TestScript;
//# sourceMappingURL=html5TestScript.js.map