"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrentTimezoneOffset = exports.getCurrentTimezone = exports.now = void 0;
const moment = require("moment-timezone");
function now(timezoneOffsetHours) {
    if (!timezoneOffsetHours) {
        timezoneOffsetHours = getCurrentTimezone();
    }
    return moment().subtract(getCurrentTimezone(), 'hour').add(timezoneOffsetHours, 'hour');
}
exports.now = now;
function getCurrentTimezone() {
    return -(new Date().getTimezoneOffset() / 60);
}
exports.getCurrentTimezone = getCurrentTimezone;
function getCurrentTimezoneOffset() {
    return new Date().getTimezoneOffset();
}
exports.getCurrentTimezoneOffset = getCurrentTimezoneOffset;
//# sourceMappingURL=dateTimeFactory.js.map