"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.overrideDateCurrentTimestampInMinutesByAsync = exports.overrideDateCurrentTimestampInSecondsByAsync = exports.overrideDateCurrentTimestampByAsync = exports.overrideDateCurrentTimestamp = void 0;
function overrideDateCurrentTimestamp(root, getCurrentTimestamp) {
    const OriginalDate = root.Date;
    const OverridenDate = function Date() {
        const args = Array.prototype.slice.call(arguments);
        if (args.length === 0) {
            // asking for current date of system
            const currentTimestamp = getCurrentTimestamp();
            const currentDate = new OverridenDate(currentTimestamp);
            if (this instanceof Date) {
                return currentDate;
            }
            else {
                return currentDate.toString();
            }
        }
        else {
            args.unshift(root);
            if (this instanceof Date) {
                return new (Function.prototype.bind.apply(OriginalDate, args))();
            }
            else {
                return OriginalDate.apply(root, args);
            }
        }
    };
    OverridenDate.now = () => getCurrentTimestamp();
    OverridenDate.parse = OriginalDate.parse;
    OverridenDate.UTC = OriginalDate.UTC;
    OverridenDate.prototype = OriginalDate.prototype;
    root.Date = OverridenDate;
    return OriginalDate;
}
exports.overrideDateCurrentTimestamp = overrideDateCurrentTimestamp;
function overrideDateCurrentTimestampByAsync(root, getCurrentTimestamp, // in milliseconds
updatingInterval = 2e3) {
    let lastCurrentTimestamp;
    let updatedAt = 0;
    const OriginalDate = overrideDateCurrentTimestamp(root, () => lastCurrentTimestamp + (OriginalDate.now() - updatedAt));
    const updateCurrentTimestamp = () => __awaiter(this, void 0, void 0, function* () {
        lastCurrentTimestamp = yield getCurrentTimestamp();
        updatedAt = OriginalDate.now();
    });
    setInterval(updateCurrentTimestamp, updatingInterval);
    updateCurrentTimestamp();
    return OriginalDate;
}
exports.overrideDateCurrentTimestampByAsync = overrideDateCurrentTimestampByAsync;
function overrideDateCurrentTimestampInSecondsByAsync(root, getCurrentTimestampSeconds, // in seconds
updatingInterval = 2e3) {
    let lastCurrentTimestamp;
    let updatedAtSeconds = 0;
    const OriginalDate = overrideDateCurrentTimestamp(root, () => lastCurrentTimestamp +
        (Math.floor(OriginalDate.now() / 1e3) - updatedAtSeconds) * 1e3 + // last update based on seconds
        (OriginalDate.now() % 1e3));
    const updateCurrentTimestamp = () => __awaiter(this, void 0, void 0, function* () {
        lastCurrentTimestamp = (yield getCurrentTimestampSeconds()) * 1e3;
        updatedAtSeconds = Math.floor(OriginalDate.now() / 1e3);
    });
    setInterval(updateCurrentTimestamp, updatingInterval);
    updateCurrentTimestamp();
    return OriginalDate;
}
exports.overrideDateCurrentTimestampInSecondsByAsync = overrideDateCurrentTimestampInSecondsByAsync;
function overrideDateCurrentTimestampInMinutesByAsync(root, getCurrentTimestampMinutes, // in minutes
updatingInterval = 10e3) {
    let lastCurrentTimestamp;
    let updatedAtMinutes = 0;
    const OriginalDate = overrideDateCurrentTimestamp(root, () => lastCurrentTimestamp +
        (Math.floor(OriginalDate.now() / 60e3) - updatedAtMinutes) * 60e3 + // last update based on seconds
        (OriginalDate.now() % 60e3));
    const updateCurrentTimestamp = () => __awaiter(this, void 0, void 0, function* () {
        lastCurrentTimestamp = (yield getCurrentTimestampMinutes()) * 60e3;
        updatedAtMinutes = Math.floor(OriginalDate.now() / 60e3);
    });
    setInterval(updateCurrentTimestamp, updatingInterval);
    updateCurrentTimestamp();
    return OriginalDate;
}
exports.overrideDateCurrentTimestampInMinutesByAsync = overrideDateCurrentTimestampInMinutesByAsync;
//# sourceMappingURL=dateMonkeyPatch.js.map