"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.enqueueMessage = exports.enqueueMessageRetryable = void 0;
const wait_1 = require("../Timer/wait");
const queueConfigurator_1 = require("./queueConfigurator");
const Debug = require("debug");
const debug = Debug('@signageos/lib:AMQP:enqueueMessage');
function enqueueMessageRetryable(amqpConnection, queueName, message, options = {}, numberOfRetrying = -1, delayBeforeRetry = 500) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            yield enqueueMessage(amqpConnection, queueName, message, options);
        }
        catch (error) {
            if (numberOfRetrying !== 0) {
                debug(`Enqueue message failed. Retry after ${delayBeforeRetry} ms`);
                yield (0, wait_1.default)(delayBeforeRetry);
                yield enqueueMessageRetryable(amqpConnection, queueName, message, options, numberOfRetrying - 1, delayBeforeRetry * 2);
            }
            else {
                throw error;
            }
        }
    });
}
exports.enqueueMessageRetryable = enqueueMessageRetryable;
function enqueueMessage(amqpConnection, queueName, message, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const connection = yield amqpConnection.pool.acquire(options.priority);
        try {
            const channel = yield connection.createConfirmChannel();
            yield (0, queueConfigurator_1.assertRejectableQueue)(channel, queueName, options.maxPriority);
            yield new Promise((resolve, reject) => channel.sendToQueue(queueName, new Buffer(JSON.stringify(message)), { persistent: true }, (error) => error !== null ? reject(error) : resolve()));
            yield amqpConnection.pool.release(connection);
        }
        catch (error) {
            yield amqpConnection.pool.destroy(connection);
            throw error;
        }
    });
}
exports.enqueueMessage = enqueueMessage;
//# sourceMappingURL=enqueueMessage.js.map