"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Debug = require("debug");
const debug = Debug('@signageos/lib:AMQP:QueuePublisher');
class QueuePublisher {
    enqueue(createChannel, message, headers = {}, exchangeName = '', routingKey, messageOptions = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            const channel = yield createChannel();
            try {
                yield channel.send(message, messageOptions, headers, exchangeName, routingKey);
                debug('Message enqueued: %s', exchangeName, routingKey, message, headers);
            }
            finally {
                yield channel.close();
            }
        });
    }
    enqueueExpectingResponse(createChannel, message, headers = {}, exchangeName = '', routingKey, messageOptions = {}, responseTimeout) {
        return __awaiter(this, void 0, void 0, function* () {
            const channel = yield createChannel();
            try {
                const response = yield channel.sendExpectingResponse(message, messageOptions, headers, exchangeName, routingKey, responseTimeout);
                debug('Message enqueued: %s', exchangeName, routingKey, message, headers);
                return response;
            }
            finally {
                yield channel.close();
            }
        });
    }
}
exports.default = QueuePublisher;
//# sourceMappingURL=QueuePublisher.js.map