"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareRejectedDetached = exports.prepareRejected = exports.prepareMany = exports.prepareMore = exports.deleteMore = exports.purgeOne = exports.waitSynchronized = exports.bindOneExpectingConfirmation = exports.bindOne = exports.fetchOneRejectedDetached = exports.bindRejectedDetached = exports.fetchOneRejected = exports.bindRejectedMany = exports.bindMany = exports.bindMore = exports.fetchAll = exports.fetchNext = exports.enqueueToConsumer = exports.enqueueNotification = exports.enqueue = void 0;
const fetchNextMessage_1 = require("../fetchNextMessage");
const deferred_1 = require("../../Promise/deferred");
const generator_1 = require("../../Hash/generator");
const ChannelProvider_1 = require("../ChannelProvider");
const EXCHANGE_PREFIX = 'events';
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
const EXCHANGE_NOTIFICATIONS_PREFIX = 'events_notifications';
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
const SYNCHRONIZATION_EXCHANGE_PREFIX = 'events_sync';
/** Alternate exchange for events (currently unused) */
const FAILED_EXCHANGE_NAME = 'events_failed';
/** Rejected exchange for (currently bindMany only) queues */
const REJECTED_EXCHANGE_NAME = 'events_rejected';
const OPTIONS = {
    persistent: true,
    confirmable: true,
    prefetchCount: 1,
};
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
const SYNCHRONIZATION_CONSUME_OPTIONS = {
    durable: false,
    exclusive: true,
    autoDelete: true,
    queueExpiresMs: 30e3, // remove after 30s when there are no consumers
};
const createEnqueueChannel = (amqpConnection, event, exchangeName) => () => __awaiter(void 0, void 0, void 0, function* () {
    const channel = yield amqpConnection.channelProvider.getChannel(event.type, OPTIONS);
    yield channel.assertExchange(FAILED_EXCHANGE_NAME, 'direct');
    yield channel.assertExchange(exchangeName, 'fanout', { alternateExchange: FAILED_EXCHANGE_NAME });
    return channel;
});
const createBindChannel = (amqpConnection, eventType, exchangeName, options) => () => __awaiter(void 0, void 0, void 0, function* () {
    const channel = yield amqpConnection.channelProvider.getChannel(eventType, Object.assign(Object.assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }));
    yield channel.assertExchange(FAILED_EXCHANGE_NAME, 'direct');
    yield channel.assertExchange(exchangeName, 'fanout', { alternateExchange: FAILED_EXCHANGE_NAME });
    return channel;
});
const createBindManyChannel = (amqpConnection, eventTypes, domainName, options) => () => __awaiter(void 0, void 0, void 0, function* () {
    const channel = yield amqpConnection.channelProvider.getChannel(domainName, Object.assign(Object.assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }));
    yield channel.assertExchange(FAILED_EXCHANGE_NAME, 'direct');
    for (const eventType of eventTypes) {
        const exchangeName = getExchangeName(options, eventType);
        yield channel.assertExchange(exchangeName, 'fanout', { alternateExchange: FAILED_EXCHANGE_NAME });
    }
    return channel;
});
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
const createSynchronizationChannel = (amqpConnection, eventType, synchronizationExchangeName) => () => __awaiter(void 0, void 0, void 0, function* () {
    const channel = yield amqpConnection.channelProvider.getChannel(eventType, OPTIONS);
    yield channel.assertExchange(synchronizationExchangeName, 'direct');
    return channel;
});
const createBindRejectedChannel = (amqpConnection, options) => () => __awaiter(void 0, void 0, void 0, function* () {
    const channel = yield amqpConnection.channelProvider.getChannel(REJECTED_EXCHANGE_NAME, Object.assign(Object.assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }));
    yield channel.assertExchange(REJECTED_EXCHANGE_NAME, 'topic');
    return channel;
});
const createBindRejectedDetachedChannel = (amqpConnection, options) => () => __awaiter(void 0, void 0, void 0, function* () {
    const channel = yield amqpConnection.channelProvider.getChannel('default', Object.assign(Object.assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }));
    // currently uses default exchange
    return channel;
});
function enqueue(amqpConnection, event, messageOptions = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const exchangeName = getExchangeName({ notification: false }, event.type);
        yield amqpConnection.queuePublisher.enqueue(createEnqueueChannel(amqpConnection, event, exchangeName), event, undefined, exchangeName, getBasicEventRoutingKey(event.type), messageOptions);
    });
}
exports.enqueue = enqueue;
/**
 * @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead
 */
function enqueueNotification(amqpConnection, event) {
    return __awaiter(this, void 0, void 0, function* () {
        const exchangeName = getExchangeName({ notification: true }, event.type);
        yield amqpConnection.queuePublisher.enqueue(createEnqueueChannel(amqpConnection, event, exchangeName), event, undefined, exchangeName, getBasicEventRoutingKey(event.type), { persistent: false });
    });
}
exports.enqueueNotification = enqueueNotification;
/**
 * @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead
 */
function enqueueSynchronized(amqpConnection, event, consumerType) {
    return __awaiter(this, void 0, void 0, function* () {
        const exchangeName = getSynchronizationExchangeName(event.type);
        yield amqpConnection.queuePublisher.enqueue(createSynchronizationChannel(amqpConnection, event.type, exchangeName), event, undefined, exchangeName, getSynchronizationEventRoutingKey(consumerType, event.commandId), { persistent: false });
    });
}
function enqueueToConsumer(amqpConnection, event, consumerType, eventTypeOrDomainName, messageOptions = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const queueName = getQueueName(consumerType, eventTypeOrDomainName !== null && eventTypeOrDomainName !== void 0 ? eventTypeOrDomainName : event.type);
        yield amqpConnection.queuePublisher.enqueue(() => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(event.type, OPTIONS);
            return channel;
        }), event, undefined, '', // default will auto route to queue with same name as routing key
        queueName, // routingKey equal to queueName (specific consumer only)
        messageOptions);
    });
}
exports.enqueueToConsumer = enqueueToConsumer;
function fetchNext(amqpConnection, eventType, consumerType, bindOptions = {}, queueOptions, domainName) {
    return __awaiter(this, void 0, void 0, function* () {
        const exchangeName = getExchangeName(bindOptions, eventType);
        const queueName = getQueueName(consumerType, eventType);
        const options = Object.assign(Object.assign(Object.assign({}, queueOptions), bindOptions), (domainName ? getDomainConsumeOptions(bindOptions, consumerType, domainName) : getConsumeOptionsByBindOptions(bindOptions)));
        return yield (0, fetchNextMessage_1.default)(amqpConnection, queueName, getBasicEventRoutingKey(eventType), exchangeName, FAILED_EXCHANGE_NAME, options, 'fanout', 'direct');
    });
}
exports.fetchNext = fetchNext;
function fetchAll(amqpConnection, eventType, consumerType, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const eventsCaught = [];
        let doNext = false;
        do {
            const event = yield fetchNext(amqpConnection, eventType, consumerType, options);
            if (event) {
                doNext = true;
                eventsCaught.push(event);
            }
            else {
                doNext = false;
            }
        } while (doNext);
        return eventsCaught;
    });
}
exports.fetchAll = fetchAll;
/**
 * @deprecated Use bindMany instead.
 * This methods only calls bindOne function for every eventType.
 * If you'd like to compose consumption of more event types into one queue, see the bindMany instead.
 */
function bindMore(amqpConnection, eventTypes, consumerType, onEvent, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        for (let eventType of eventTypes) {
            yield bindOne(amqpConnection, eventType, consumerType, onEvent, options);
        }
    });
}
exports.bindMore = bindMore;
/**
 * Bind more event types into one single queue.
 * This queue name contains specified domainName and is prefixed by consumerType.
 */
function bindMany(amqpConnection, eventTypes, domainName, consumerType, onEvent, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const queueName = getQueueName(consumerType, domainName);
        const bindings = eventTypes.map((eventType) => {
            const exchangeName = getExchangeName(options, eventType);
            return { exchangeName, routingKey: getBasicEventRoutingKey(eventType), persistent: true };
        });
        const consumeOptions = getDomainConsumeOptions(options, consumerType, domainName);
        return yield amqpConnection.queueSubscriber.subscribeRepeatable(createBindManyChannel(amqpConnection, eventTypes, domainName, options), queueName, bindings, (event) => __awaiter(this, void 0, void 0, function* () {
            yield onEvent(event);
            yield enqueueSynchronized(amqpConnection, event, consumerType);
        }), consumeOptions);
    });
}
exports.bindMany = bindMany;
/**
 * Bind all events which were rejected with enqueue=false by bindMany function (the domain type only).
 */
function bindRejectedMany(amqpConnection, domainName, consumerType, onEvent, redeliverOptions, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const queueName = getRejectedManyQueueName(consumerType, domainName);
        return yield amqpConnection.queueSubscriber.subscribeRepeatable(createBindRejectedChannel(amqpConnection, options), queueName, [{ exchangeName: REJECTED_EXCHANGE_NAME, routingKey: getRejectedDomainRoutingKey(consumerType, domainName), persistent: true }], onEvent, getRejectedManyConsumeOptions(options, consumerType, domainName, redeliverOptions));
    });
}
exports.bindRejectedMany = bindRejectedMany;
/**
 * Fetch on event which were rejected with enqueue=false by bindMany function (the domain type only).
 * Returns message containing event which has to by explicitly acked/nacked.
 */
function fetchOneRejected(amqpConnection, domainName, consumerType) {
    return __awaiter(this, void 0, void 0, function* () {
        const queueName = getRejectedManyQueueName(consumerType, domainName);
        const connection = yield amqpConnection.pool.acquire();
        const channel = yield connection.createConfirmChannel();
        const finish = () => __awaiter(this, void 0, void 0, function* () {
            try {
                yield channel.close();
                yield amqpConnection.pool.release(connection);
            }
            catch (error) {
                yield amqpConnection.pool.destroy(connection);
                throw error;
            }
        });
        const message = yield channel.get(queueName);
        if (!message) {
            yield finish();
            return null;
        }
        const event = amqpConnection.channelProvider.decodeMessageBuffer(message.content);
        const originalQueueName = message.properties.headers['x-first-death-queue'];
        if (!originalQueueName) {
            yield finish();
            throw new Error(`Message is missing original queue name "x-first-death-queue"`);
        }
        const domain = parseQueueName(consumerType, originalQueueName);
        return {
            event,
            domain,
            ack() {
                return __awaiter(this, void 0, void 0, function* () {
                    channel.ack(message);
                    yield finish();
                });
            },
            nack(nackOptions) {
                return __awaiter(this, void 0, void 0, function* () {
                    channel.nack(message, undefined, nackOptions === null || nackOptions === void 0 ? void 0 : nackOptions.requeue);
                    yield finish();
                });
            },
        };
    });
}
exports.fetchOneRejected = fetchOneRejected;
/**
 * Bind one event which were rejected with enqueue=false by bindOne function (the detached type only).
 */
function bindRejectedDetached(amqpConnection, eventType, consumerType, onEvent, redeliverOptions, bindOptions = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const queueName = getRejectedDetachedQueueName(consumerType, eventType);
        return yield amqpConnection.queueSubscriber.subscribeRepeatable(createBindRejectedDetachedChannel(amqpConnection, bindOptions), queueName, [
            { exchangeName: '', routingKey: queueName, persistent: true }, // this is default binding defined by AMQP protocol
        ], onEvent, getRejectedDetachedConsumeOptions(bindOptions, consumerType, eventType, redeliverOptions));
    });
}
exports.bindRejectedDetached = bindRejectedDetached;
/**
 * Fetch on event which were rejected with enqueue=false by bindOne function (the detached type only).
 * Returns message containing event which has to by explicitly acked/nacked.
 */
function fetchOneRejectedDetached(amqpConnection, eventType, consumerType) {
    return __awaiter(this, void 0, void 0, function* () {
        const queueName = getRejectedDetachedQueueName(consumerType, eventType);
        const connection = yield amqpConnection.pool.acquire();
        const channel = yield connection.createConfirmChannel();
        const finish = () => __awaiter(this, void 0, void 0, function* () {
            try {
                yield channel.close();
                yield amqpConnection.pool.release(connection);
            }
            catch (error) {
                yield amqpConnection.pool.destroy(connection);
                throw error;
            }
        });
        const message = yield channel.get(queueName);
        if (!message) {
            yield finish();
            return null;
        }
        const event = amqpConnection.channelProvider.decodeMessageBuffer(message.content);
        return {
            event,
            ack() {
                return __awaiter(this, void 0, void 0, function* () {
                    channel.ack(message);
                    yield finish();
                });
            },
            nack(nackOptions) {
                return __awaiter(this, void 0, void 0, function* () {
                    channel.nack(message, undefined, nackOptions === null || nackOptions === void 0 ? void 0 : nackOptions.requeue);
                    yield finish();
                });
            },
        };
    });
}
exports.fetchOneRejectedDetached = fetchOneRejectedDetached;
function bindOne(amqpConnection, eventType, consumerType, onEvent, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const exchangeName = getExchangeName(options, eventType);
        const queueName = getQueueName(consumerType, eventType);
        return yield amqpConnection.queueSubscriber.subscribeRepeatable(createBindChannel(amqpConnection, eventType, exchangeName, options), queueName, [{ exchangeName, routingKey: getBasicEventRoutingKey(eventType), persistent: true }], (event) => __awaiter(this, void 0, void 0, function* () {
            yield onEvent(event);
            yield enqueueSynchronized(amqpConnection, event, consumerType);
        }), getConsumeOptionsByBindOptions(options));
    });
}
exports.bindOne = bindOne;
function bindOneExpectingConfirmation(amqpConnection, eventType, consumerType, onEvent, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const exchangeName = getExchangeName(options, eventType);
        const queueName = getQueueName(consumerType, eventType);
        return yield amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(createBindChannel(amqpConnection, eventType, exchangeName, options), queueName, [{ exchangeName, routingKey: getBasicEventRoutingKey(eventType), persistent: true }], (event, _headers, ack, nack) => __awaiter(this, void 0, void 0, function* () {
            const ackWithSync = () => __awaiter(this, void 0, void 0, function* () {
                yield enqueueSynchronized(amqpConnection, event, consumerType);
                ack();
            });
            yield onEvent(event, ackWithSync, nack);
        }), getConsumeOptionsByBindOptions(options));
    });
}
exports.bindOneExpectingConfirmation = bindOneExpectingConfirmation;
/**
 * @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead
 */
function waitSynchronized(amqpConnection, eventType, consumerType, commandId) {
    return __awaiter(this, void 0, void 0, function* () {
        const deferred = (0, deferred_1.createDeferred)();
        const exchangeName = getSynchronizationExchangeName(eventType);
        const queueName = generateSynchronizationQueueName(consumerType, eventType, commandId);
        const cancelSubscription = yield amqpConnection.queueSubscriber.subscribeRepeatable(createSynchronizationChannel(amqpConnection, eventType, exchangeName), queueName, [{ exchangeName, routingKey: getSynchronizationEventRoutingKey(consumerType, commandId), persistent: false }], (event) => __awaiter(this, void 0, void 0, function* () {
            deferred.resolve(event);
        }), SYNCHRONIZATION_CONSUME_OPTIONS);
        return {
            promise: deferred.promise,
            cancelSubscription,
        };
    });
}
exports.waitSynchronized = waitSynchronized;
function purgeOne(amqpConnection, eventType, consumerType) {
    return __awaiter(this, void 0, void 0, function* () {
        const queueName = getQueueName(consumerType, eventType);
        const channel = yield amqpConnection.channelProvider.getChannel(eventType);
        try {
            yield channel.purge(queueName);
        }
        finally {
            yield channel.close();
        }
    });
}
exports.purgeOne = purgeOne;
function deleteMore(amqpConnection, eventTypes, consumerType) {
    return __awaiter(this, void 0, void 0, function* () {
        for (let eventType of eventTypes) {
            const queueName = getQueueName(consumerType, eventType);
            const channel = yield amqpConnection.channelProvider.getChannel(eventType);
            try {
                yield channel.delete(queueName);
            }
            finally {
                yield channel.close();
            }
        }
    });
}
exports.deleteMore = deleteMore;
function prepareMore(amqpConnection, events, consumerType, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        for (const event of events) {
            // Hack to create event queue for exchange
            yield fetchNext(amqpConnection, event, consumerType, options);
        }
    });
}
exports.prepareMore = prepareMore;
function prepareMany(amqpConnection, events, domainName, consumerType, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const cancel = yield bindMany(amqpConnection, events, domainName, consumerType, () => __awaiter(this, void 0, void 0, function* () { return new Promise(() => undefined); }), options);
        const close = yield cancel();
        yield close();
    });
}
exports.prepareMany = prepareMany;
function prepareRejected(amqpConnection, domainName, consumerType, redeliverOptions, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const cancel = yield bindRejectedMany(amqpConnection, domainName, consumerType, () => __awaiter(this, void 0, void 0, function* () { return new Promise(() => undefined); }), redeliverOptions, options);
        const close = yield cancel();
        yield close();
    });
}
exports.prepareRejected = prepareRejected;
function prepareRejectedDetached(amqpConnection, eventType, consumerType, redeliverOptions, bindOptions = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const cancel = yield bindRejectedDetached(amqpConnection, eventType, consumerType, () => __awaiter(this, void 0, void 0, function* () { return new Promise(() => undefined); }), redeliverOptions, bindOptions);
        const close = yield cancel();
        yield close();
    });
}
exports.prepareRejectedDetached = prepareRejectedDetached;
function getDomainConsumeOptions(options, consumerType, domainName) {
    return Object.assign(Object.assign({}, getConsumeOptionsByBindOptions(options)), { deadLetterExchange: REJECTED_EXCHANGE_NAME, deadLetterRoutingKey: getRejectedDomainRoutingKey(consumerType, domainName) });
}
function getRejectedManyConsumeOptions(bindOptions, consumerType, domainName, redeliverOptions) {
    const queueName = getQueueName(consumerType, domainName);
    return Object.assign(Object.assign({}, getConsumeOptionsByBindOptions(bindOptions)), { deadLetterExchange: '', deadLetterRoutingKey: queueName, messageExpiresMs: redeliverOptions.redeliverDelayMs, queueType: 'classic' });
}
function getRejectedDetachedConsumeOptions(bindOptions, consumerType, eventType, redeliverOptions) {
    const queueName = getQueueName(consumerType, eventType);
    return Object.assign(Object.assign({}, getConsumeOptionsByBindOptions(bindOptions)), { deadLetterExchange: '', deadLetterRoutingKey: queueName, messageExpiresMs: redeliverOptions.redeliverDelayMs, queueType: 'classic' });
}
function getConsumeOptionsByBindOptions(options) {
    return {
        autoDelete: typeof options.persistent !== 'undefined' ? !options.persistent : false,
        exclusive: typeof options.exclusive !== 'undefined' ? options.exclusive : false,
        redeliverDelayMs: typeof options.redeliverDelayMs !== 'undefined' ? options.redeliverDelayMs : 1e3,
        suppressFirstError: typeof options.suppressFirstError !== 'undefined' ? options.suppressFirstError : true,
        singleActiveConsumer: options.singleActiveConsumer,
        deadLetterIfRedeliveredAndErred: options.deadLetterIfRedeliveredAndErred,
        queueType: typeof options.queueType !== 'undefined' ? options.queueType : 'quorum', // default for event queues are swapped
    };
}
function getExchangeName(options, eventType) {
    const prefix = options.notification ? EXCHANGE_NOTIFICATIONS_PREFIX : EXCHANGE_PREFIX;
    return `${prefix}-${eventType}`;
}
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
function getSynchronizationExchangeName(eventType) {
    return `${SYNCHRONIZATION_EXCHANGE_PREFIX}-${eventType}`;
}
function getQueueName(consumerType, eventTypeOrDomainName) {
    return consumerType + '_' + eventTypeOrDomainName;
}
function parseQueueName(consumerType, queueName) {
    const eventTypeOrDomainName = queueName.substring(consumerType.length + 1);
    const expectedQueueName = getQueueName(consumerType, eventTypeOrDomainName);
    if (expectedQueueName !== queueName) {
        throw new Error(`Incorrect queue name cannot be parsed: ${consumerType}, ${queueName}`);
    }
    return eventTypeOrDomainName;
}
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
function generateSynchronizationQueueName(consumerType, eventType, commandId) {
    return '_synchronization_' + consumerType + '_' + eventType + '_' + commandId + '_' + (0, generator_1.generateUniqueHash)(6);
}
function getRejectedManyQueueName(consumerType, domainName) {
    return 'events_rejected.' + getQueueName(consumerType, domainName);
}
function getRejectedDetachedQueueName(consumerType, eventType) {
    return ChannelProvider_1.REJECTED_QUEUE_PREFIX + getQueueName(consumerType, eventType);
}
function escapeEventTypeForRoutingKey(eventType) {
    return eventType.replace(/\./g, '_');
}
function escapeConsumerTypeForRoutingKey(consumerType) {
    return consumerType.replace(/\./g, '_');
}
function getBasicEventRoutingKey(eventType) {
    return 'event.' + escapeEventTypeForRoutingKey(eventType);
}
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
function getSynchronizationEventRoutingKey(consumerType, commandId) {
    return 'event_sync.' + escapeConsumerTypeForRoutingKey(consumerType) + '.' + commandId;
}
function getRejectedDomainRoutingKey(consumerType, domainName) {
    return 'domain.' + consumerType + '.' + domainName;
}
//# sourceMappingURL=eventQueue.js.map