import { IAMQPConnection } from '../../amqpConnectionFactory';
import { IEventPayload } from '../IEvent';
import { EventCallback, IEventConsumer } from './IEventConsumer';
/**
 * High level abstraction of event consumption
 *
 * This implementation uses AMQP queues to consume events.
 *
 * It abstracts all the implementation details of setting up consumption of events
 * and provides a simple interface so that the consumer can focus on just handling the events.
 *
 * All events are consumed from a single queue in a sequential order.
 * The name of the queue will be constructed from the consumer name and the domain as "<consumerName>_<domain>".
 */
export declare class AmqpEventConsumer implements IEventConsumer {
    private amqpConnection;
    private consumerName;
    private domain;
    private consumerCallbacks;
    private stopCallback;
    private started;
    /**
     * @param amqpConnection The AMQP connection to use
     * @param consumerName The name of the consumer. This is used to identify the consumer in the AMQP queue
     * @param domain The domain to consume events from. Defaults to 'default'
     */
    constructor({ amqpConnection, consumerName, domain }: {
        amqpConnection: IAMQPConnection;
        consumerName: string;
        domain?: string;
    });
    /**
     * Add a consumer for a specific event type
     *
     * Has to be called before calling listen(), otherwise it will throw an error.
     */
    addEventConsumer<TPayload extends IEventPayload>(eventType: string, callback: EventCallback<TPayload>): void;
    listen(): Promise<void>;
    close(): Promise<void>;
    private bindEvents;
    private consumeEvent;
}
