"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var path = require("path");
var fs = require("fs-extra");
var tar = require("tar");
var tmp = require("tmp");
var child_process_1 = require("child_process");
var NpmPackPlugin = /** @class */ (function () {
    function NpmPackPlugin(options) {
        this.options = options;
    }
    NpmPackPlugin.prototype.apply = function (compiler) {
        var _this = this;
        var hook = function () {
            if (_this.options.environment === 'dev') {
                var timestampNumber = new Date().toISOString().replace(/[^\d]/gi, '').substr(0, 14);
                var devVersion = (_this.options.getVersion ? _this.options.getVersion() : '99.0.0-dev') + '.' + timestampNumber;
                var tmpDir = tmp.dirSync().name;
                fs.copySync(path.join(_this.options.rootPath, 'dist'), path.join(tmpDir, 'package', 'dist'));
                fs.copySync(path.join(_this.options.rootPath, 'README.md'), path.join(tmpDir, 'package', 'README.md'));
                var configPath = path.join(_this.options.rootPath, 'package.json');
                var configContents = fs.readJSONSync(configPath);
                configContents.version = devVersion;
                fs.writeJSONSync(path.join(tmpDir, 'package', 'package.json'), configContents);
                var tarballDir = path.join(_this.options.packagesPath, _this.options.name, devVersion);
                var tarballFileName = _this.options.name.replace(/^@/, '').replace(/\//g, '-') + '-' + devVersion + '.tgz';
                fs.ensureDirSync(tarballDir);
                tar.c({
                    gzip: true,
                    file: path.join(tarballDir, tarballFileName),
                    sync: true,
                    cwd: tmpDir,
                }, ['package']);
                _this.packDependencies();
                console.info('Tarball release ' + tarballFileName);
            }
        };
        if ('plugin' in compiler && typeof compiler.plugin === 'function') {
            compiler.plugin('done', hook);
        }
        else {
            compiler.hooks.done.tapAsync({ name: 'NpmPackPlugin' }, hook);
        }
    };
    NpmPackPlugin.prototype.packDependencies = function () {
        var configLockPath = path.join(this.options.rootPath, 'package-lock.json');
        var configLockContents = fs.readJSONSync(configLockPath);
        var dependencies = this.options.dependencies || [];
        for (var _i = 0, dependencies_1 = dependencies; _i < dependencies_1.length; _i++) {
            var dependency = dependencies_1[_i];
            var dependencyVersion = 'dependencies' in configLockContents
                ? // lockfileVersion 0 and 1
                    configLockContents.dependencies[dependency].version
                : // lockfileVersion 2 and 3
                    configLockContents.packages['node_modules/' + dependency].version;
            var dependencyVersionPath = path.join(this.options.packagesPath, dependency, dependencyVersion);
            if (!fs.existsSync(dependencyVersionPath)) {
                var fileName = (0, child_process_1.execSync)("npm pack ".concat(dependency, "@").concat(dependencyVersion)).toString().trim();
                fs.ensureDirSync(dependencyVersionPath);
                fs.moveSync(path.join(this.options.rootPath, fileName), path.join(dependencyVersionPath, fileName));
            }
        }
    };
    return NpmPackPlugin;
}());
exports.default = NpmPackPlugin;
//# sourceMappingURL=NpmPackPlugin.js.map