"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function wait(timeout) {
    var timer = undefined;
    var rejectCallback = null;
    var promise = new Promise(function (resolve, reject) {
        rejectCallback = reject;
        timer = setTimeout(function () {
            rejectCallback = null;
            resolve();
        }, timeout);
    });
    promise.cancel = function () {
        if (timer) {
            clearTimeout(timer);
            timer = undefined;
            if (rejectCallback) {
                rejectCallback(new Error('Wait cancelled'));
            }
            rejectCallback = null;
        }
    };
    return promise;
}
exports.default = wait;
//# sourceMappingURL=wait.js.map