"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initDbConnectionsMetrics = void 0;
var connection_1 = require("../../ThirdParty/connection");
var mongodb_1 = require("./mongodb");
function initDbConnectionsMetrics(connections, metricsClient) {
    if (connections.amqp) {
        initMetricsForDBType(metricsClient, 'amqp', connections.amqp);
    }
    if (connections.redis) {
        initMetricsForDBType(metricsClient, 'redis', connections.redis);
    }
    if (connections.postgres) {
        initMetricsForDBType(metricsClient, 'postgres', connections.postgres);
    }
    if (connections.mongodb) {
        (0, mongodb_1.initMongoDBConnectionsMetrics)(metricsClient, connections.mongodb);
    }
}
exports.initDbConnectionsMetrics = initDbConnectionsMetrics;
function initMetricsForDBType(metricsClient, dbName, connections) {
    var client = metricsClient.getClient();
    for (var _i = 0, _a = Object.keys(connections); _i < _a.length; _i++) {
        var connName = _a[_i];
        var connection = connections[connName];
        var metricPrefix = "sos_service_db_connections_".concat(dbName, "_").concat(connName, "_");
        var openMetric = new client.Gauge({
            name: metricPrefix + 'open',
            help: 'Count of open AMQP connections for the entire runtime history',
        });
        var closeMetric = new client.Gauge({
            name: metricPrefix + 'close',
            help: 'Count of closed AMQP connections for the entire runtime history',
        });
        updateMetricWithConnection(connection, openMetric, closeMetric);
    }
}
function updateMetricWithConnection(connection, openMetric, closeMetric) {
    connection.addListener(connection_1.ThirdPartyConnectionEvent.ConnectionOpen, function () {
        openMetric.inc();
    });
    connection.addListener(connection_1.ThirdPartyConnectionEvent.ConnectionClosed, function () {
        closeMetric.inc();
    });
}
//# sourceMappingURL=connections.js.map