import { IProgressiveWait } from '../Timer/progressiveWait';
/**
 * Repeatedly try to call the callback function until it successfully resolves
 * or the number of attempts reaches the passed count of attempts.
 * Throws an error otherwise.
 */
export declare const retryAsync: <T>(count: number, callback: () => Promise<T>, progressiveWait?: IProgressiveWait) => Promise<T>;
export declare class PredicateNotMetError extends Error {
    constructor(message: string);
}
/**
 * Repeatedly try to call the callback function until the passed predicate function returns true
 * or the number of attempts reaches the passed count of attempts.
 * Throws an error otherwise.
 */
export declare const retryAsyncUntil: <T>({ callback, predicate, progressiveWait, count, attemptErrorLog, }: {
    callback: () => Promise<T>;
    predicate: (payload: T) => boolean;
    /** @default createProgressiveWait(500) */
    progressiveWait?: IProgressiveWait | undefined;
    /** @default 10 */
    count?: number | undefined;
    /**
     * @param e error that was thrown by callback
     * @description logs error that was thrown by callback
     */
    attemptErrorLog?: ((e: Error) => void) | undefined;
}) => Promise<T>;
