"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LockAcquisitionError = exports.redisLock = void 0;
var wait_1 = require("../Timer/wait");
var generator_1 = require("../Hash/generator");
var DEFAULT_RETRY_DELAY = 200;
var DEFAULT_PROLONG_INTERVAL = 10000;
var DEFAULT_TTL_EXTRA_TIMEOUT = 5000;
var redisLock = function (client) { return function (key, options) { return __awaiter(void 0, void 0, void 0, function () {
    var acquireStartedAt, retryDelay, currentTime, error_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                acquireStartedAt = new Date();
                retryDelay = options.retryDelay || DEFAULT_RETRY_DELAY;
                _a.label = 1;
            case 1:
                if (!true) return [3 /*break*/, 7];
                currentTime = new Date();
                if (currentTime.valueOf() - acquireStartedAt.valueOf() >= options.acquireTimeout) {
                    throw new LockAcquisitionError("Could not acquire lock on \"".concat(key, "\""));
                }
                _a.label = 2;
            case 2:
                _a.trys.push([2, 4, , 5]);
                return [4 /*yield*/, createLock(client, key, options)];
            case 3: return [2 /*return*/, _a.sent()];
            case 4:
                error_1 = _a.sent();
                return [3 /*break*/, 5];
            case 5: return [4 /*yield*/, (0, wait_1.default)(retryDelay)];
            case 6:
                _a.sent();
                return [3 /*break*/, 1];
            case 7: return [2 /*return*/];
        }
    });
}); }; };
exports.redisLock = redisLock;
var LockAcquisitionError = /** @class */ (function (_super) {
    __extends(LockAcquisitionError, _super);
    function LockAcquisitionError() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return LockAcquisitionError;
}(Error));
exports.LockAcquisitionError = LockAcquisitionError;
function createLock(client, key, options) {
    return __awaiter(this, void 0, void 0, function () {
        var lockUid, prolongInterval, ttlExtraTimeout, ttl, reply, prolonger, releaseCb, releaseTimeout;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    lockUid = (0, generator_1.generateUniqueHash)();
                    prolongInterval = options.prolongInterval || DEFAULT_PROLONG_INTERVAL;
                    ttlExtraTimeout = options.ttlExtraTimeout || DEFAULT_TTL_EXTRA_TIMEOUT;
                    ttl = prolongInterval + ttlExtraTimeout;
                    return [4 /*yield*/, redisSet(client, key, lockUid, 'PX', ttl, 'NX')];
                case 1:
                    reply = _a.sent();
                    if (reply !== 'OK') {
                        throw new LockAcquisitionError("Could not create lock on \"".concat(key, "\". Reason: Already exists."));
                    }
                    prolonger = setInterval(function () { return __awaiter(_this, void 0, void 0, function () {
                        var currentLockUid;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, redisGet(client, key)];
                                case 1:
                                    currentLockUid = _a.sent();
                                    if (currentLockUid !== lockUid) {
                                        // This should never happen when used the same version of redisLock and nothing else writes to redis
                                        throw new Error("Lock was stolen by other process: \"".concat(key, "\". Uid ").concat(lockUid, " was expected but ").concat(currentLockUid, " given."));
                                    }
                                    return [4 /*yield*/, redisSet(client, key, lockUid, 'PX', ttl, 'XX')];
                                case 2:
                                    _a.sent();
                                    return [2 /*return*/];
                            }
                        });
                    }); }, prolongInterval);
                    releaseCb = createReleaseCallback(client, key, prolonger);
                    releaseTimeout = setTimeout(function () {
                        console.warn("redisLock releaseTimeout ".concat(options.releaseTimeout, "ms reached for key \"").concat(key, "\""));
                        releaseCb();
                    }, options.releaseTimeout);
                    return [2 /*return*/, function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        clearTimeout(releaseTimeout);
                                        return [4 /*yield*/, releaseCb()];
                                    case 1:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); }];
            }
        });
    });
}
function createReleaseCallback(client, key, prolonger) {
    var _this = this;
    var runningProlonger = prolonger;
    return function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!(runningProlonger !== null)) return [3 /*break*/, 2];
                    clearInterval(runningProlonger);
                    runningProlonger = null;
                    return [4 /*yield*/, redisDel(client, key)];
                case 1:
                    _a.sent();
                    _a.label = 2;
                case 2: return [2 /*return*/];
            }
        });
    }); };
}
function redisGet(client, key) {
    return new Promise(function (resolve, reject) {
        client.get(key, function (error, value) {
            if (error) {
                reject(error);
            }
            else {
                resolve(value);
            }
        });
    });
}
function redisSet(client, key, value, mode, duration, flag) {
    return new Promise(function (resolve, reject) {
        client.set(key, value, mode, duration, flag, function (error, reply) {
            if (error) {
                reject(error);
            }
            else {
                resolve(reply);
            }
        });
    });
}
function redisDel(client, key) {
    return new Promise(function (resolve, reject) {
        client.del(key, function (error, reply) {
            if (error) {
                reject(error);
            }
            else {
                resolve(reply);
            }
        });
    });
}
//# sourceMappingURL=redisLock.js.map