import * as mongodb from 'mongodb';
import { IConnectionStringHost, IConnectionStringParameters } from 'connection-string-parser';
export declare function tryConnection(host: IConnectionStringHost, parameters: IConnectionStringParameters): Promise<mongodb.BSON.Document>;
export declare function getDsn(host: IConnectionStringHost, parameters: IConnectionStringParameters, omitParamNames?: string[]): string;
export declare function withoutOptions(parameters: IConnectionStringParameters, omitParamNames?: string[]): {
    options: Pick<any, number | symbol>;
    scheme: string;
    username?: string | undefined;
    password?: string | undefined;
    hosts: IConnectionStringHost[];
    endpoint?: string | undefined;
};
export declare function doConnectionCallback<T>(host: IConnectionStringHost, parameters: IConnectionStringParameters, callback: (conn: mongodb.MongoClient) => Promise<T>): Promise<T>;
