"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MongoDBConnection = void 0;
var mongoose = require("mongoose");
var Debug = require("debug");
var proprietaryCluster_1 = require("./proprietaryCluster");
var genericGracefulExit_1 = require("../Events/genericGracefulExit");
mongoose.Promise = Promise;
var debug = Debug('@signageos/lib:MongoDB:mongoDBConnectionFactory');
var defaultOptions = {
    autoIndex: false,
    connectTimeoutMS: 10 * 60 * 1e3,
    socketTimeoutMS: 3 * 60 * 60 * 1e3,
    monitorCommands: true,
};
var MongoDBConnection = /** @class */ (function () {
    function MongoDBConnection(mongoDbDsn, options, onExit) {
        if (options === void 0) { options = {}; }
        this.mongoDbDsn = mongoDbDsn;
        this.connection = null;
        this.metrics = null;
        this.options = __assign(__assign({}, defaultOptions), options);
        var reconnectTimeout = 30e3;
        this.gracefulExit = new genericGracefulExit_1.GenericGracefulExit('mongo', reconnectTimeout, onExit);
    }
    MongoDBConnection.prototype.connect = function () {
        return __awaiter(this, void 0, void 0, function () {
            var updatedMongDbDsn, connection;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        debug('connect');
                        return [4 /*yield*/, (0, proprietaryCluster_1.updateDsnIfProprietaryCluster)(this.mongoDbDsn)];
                    case 1:
                        updatedMongDbDsn = _a.sent();
                        connection = mongoose.createConnection(updatedMongDbDsn, this.options);
                        this.applyGracefulExit(connection);
                        if (this.metrics) {
                            this.monitorConnection(connection, this.metrics.exporter, this.metrics.connectionName);
                        }
                        return [4 /*yield*/, connection.asPromise()];
                    case 2:
                        _a.sent();
                        debug('connected');
                        this.connection = connection;
                        return [2 /*return*/];
                }
            });
        });
    };
    MongoDBConnection.prototype.close = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.connection) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.connection.close()];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    MongoDBConnection.prototype.monitor = function (exporter, connectionName) {
        if (this.connection) {
            debug("monitor connection ".concat(connectionName, " now"));
            this.monitorConnection(this.connection, exporter, connectionName);
        }
        else {
            debug("monitor connection ".concat(connectionName, ", once it connects"));
            // if connection is not yet established, store the exporter and name for later use
            this.metrics = {
                exporter: exporter,
                connectionName: connectionName,
            };
        }
    };
    MongoDBConnection.prototype.applyGracefulExit = function (connection) {
        var _this = this;
        connection.on('disconnected', function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.gracefulExit.waitToConnectOrDie()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        }); });
        connection.on('error', function (_err) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.gracefulExit.waitToConnectOrDie()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        }); });
        connection.on('connected', function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.gracefulExit.connected();
                return [2 /*return*/];
            });
        }); });
        connection.on('close', function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.gracefulExit.closed();
                return [2 /*return*/];
            });
        }); });
    };
    /**
     * @see https://www.mongodb.com/docs/drivers/node/current/fundamentals/monitoring/command-monitoring/#command-monitoring
     */
    MongoDBConnection.prototype.monitorConnection = function (connection, exporter, connectionName) {
        debug("monitor connection ".concat(connectionName));
        var mongoClient = connection.getClient();
        exporter.monitorMongoClient(mongoClient, connectionName);
        var eventNames = ['commandStarted', 'commandSucceeded', 'commandFailed'];
        var _loop_1 = function (eventName) {
            mongoClient.addListener(eventName, function (event) {
                debug(eventName, 
                // https://github.com/GoogleChromeLabs/jsbi/issues/30
                JSON.stringify(event, function (_key, value) { return (typeof value === 'bigint' ? value.toString() : value); }));
            });
        };
        for (var _i = 0, eventNames_1 = eventNames; _i < eventNames_1.length; _i++) {
            var eventName = eventNames_1[_i];
            _loop_1(eventName);
        }
    };
    return MongoDBConnection;
}());
exports.MongoDBConnection = MongoDBConnection;
//# sourceMappingURL=MongoDBConnection.js.map