"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initSentry = void 0;
var Sentry = require("isomorphic-sentry");
function initSentry(options) {
    Sentry.init({
        enabled: options.enabled,
        dsn: options.config.dsn,
        release: options.config.release,
        environment: options.config.environment,
    });
    Sentry.configureScope(function (scope) {
        scope.setTag('application', options.config.tags.application);
    });
}
exports.initSentry = initSentry;
//# sourceMappingURL=sentry.js.map