"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRavenLogging = void 0;
var Raven = require("raven");
function useRavenLogging() {
    // override default console logging
    var consoleWarn = console.warn;
    var consoleError = console.error;
    console.warn = function (message) {
        var optionalParams = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            optionalParams[_i - 1] = arguments[_i];
        }
        consoleWarn.call.apply(consoleWarn, __spreadArray([console, message], optionalParams, false));
        if (typeof message !== 'string' || !message.startsWith('raven')) {
            captureRaven.apply(void 0, __spreadArray(['warning', 'warn', message], optionalParams, false));
        }
    };
    console.error = function (message) {
        var optionalParams = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            optionalParams[_i - 1] = arguments[_i];
        }
        consoleError.call.apply(consoleError, __spreadArray([console, message], optionalParams, false));
        if (typeof message !== 'string' || !message.startsWith('raven')) {
            captureRaven.apply(void 0, __spreadArray(['error', 'error', message], optionalParams, false));
        }
    };
}
exports.useRavenLogging = useRavenLogging;
function captureRaven(level, source, message) {
    var optionalParams = [];
    for (var _i = 3; _i < arguments.length; _i++) {
        optionalParams[_i - 3] = arguments[_i];
    }
    var options = {
        level: level,
        tags: {
            source: source,
        },
        extra: optionalParams,
    };
    if (message instanceof Error) {
        Raven.captureException(message, options);
    }
    else {
        if (typeof message === 'string') {
            message = message;
        }
        else {
            message = JSON.stringify(message);
        }
        Raven.captureMessage(message, options);
    }
}
//# sourceMappingURL=raven.js.map