export type IGetStatus = (timeoutMs: number) => Promise<IServicesGroupResponse>;
export interface IServicesGroupResponse {
    [serviceName: string]: IStatusResponse;
}
export type IStatusResponse = {
    response: {
        requestedAt: number;
        respondedAt: number;
        responseTime: number;
    };
} | {
    error: {
        message: string;
        requestedAt: number;
        failedAt: number;
        errorTime: number;
    };
};
export default function <Connection>(connections: Connection[], checkStatus: (conn: Connection, uid: string) => Promise<object>, label: string, serviceUid?: string): IGetStatus;
