"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendStatusResponse = void 0;
var time = require("../DateTime/dateTimeFactory");
var os = require("os");
var HttpStatus = require("http-status");
function sendStatusResponse(req, res, name, uid, timeout, statusRequestedAt, serviceGroupResponses, additionalDataCallback) {
    if (additionalDataCallback === void 0) { additionalDataCallback = function () { return undefined; }; }
    var serviceNames = Object.keys(serviceGroupResponses);
    var failedServices = serviceNames.filter(function (serviceName) { return 'error' in serviceGroupResponses[serviceName]; });
    var succeededServices = serviceNames.filter(function (serviceName) { return 'response' in serviceGroupResponses[serviceName]; });
    var success = failedServices.length === 0;
    var statusResponse = {
        name: name,
        status: success ? 'OK' : 'FAILED',
        process: {
            uid: uid,
            pid: process.pid,
            version: process.version,
            uptime: process.uptime(),
            cpuUsage: process.cpuUsage(),
            memoryUsage: process.memoryUsage(),
        },
        hostname: os.hostname(),
        failedServices: failedServices,
        succeededServices: succeededServices,
        timeout: timeout,
        requestedAt: statusRequestedAt.valueOf(),
        respondedAt: time.now().valueOf(),
    };
    var response = __assign(__assign(__assign({}, statusResponse), additionalDataCallback(req)), serviceGroupResponses);
    res.status(success ? HttpStatus.OK : HttpStatus.SERVICE_UNAVAILABLE).send(response);
}
exports.sendStatusResponse = sendStatusResponse;
//# sourceMappingURL=sendStatusResponse.js.map