"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getModuleExportsRecursive = exports.getStringValuesRecursive = void 0;
var fs = require("fs");
function getStringValuesRecursive(path) {
    var dirs = fs.readdirSync(path);
    var values = [];
    for (var _i = 0, dirs_1 = dirs; _i < dirs_1.length; _i++) {
        var dir = dirs_1[_i];
        var filePath = path + '/' + dir;
        var stats = fs.statSync(filePath);
        if (stats.isDirectory()) {
            values = __spreadArray(__spreadArray([], values, true), getStringValuesRecursive(filePath), true);
        }
        else if (dir.substr(dir.lastIndexOf('.')) === '.js') {
            var module_1 = require(filePath);
            for (var name_1 in module_1) {
                if (typeof module_1[name_1] === 'string') {
                    values = __spreadArray(__spreadArray([], values, true), [module_1[name_1]], false);
                }
            }
        }
    }
    return values;
}
exports.getStringValuesRecursive = getStringValuesRecursive;
function getModuleExportsRecursive(path, relativeBasePath) {
    if (relativeBasePath === void 0) { relativeBasePath = '.'; }
    var dirs = fs.readdirSync(path);
    var moduleExports = [];
    for (var _i = 0, dirs_2 = dirs; _i < dirs_2.length; _i++) {
        var dir = dirs_2[_i];
        var filePath = path + '/' + dir;
        var stats = fs.statSync(filePath);
        if (stats.isDirectory()) {
            moduleExports = __spreadArray(__spreadArray([], moduleExports, true), getModuleExportsRecursive(filePath, relativeBasePath + '/' + dir), true);
        }
        else if (dir.substr(dir.lastIndexOf('.')) === '.js') {
            var relativePath = relativeBasePath + '/' + dir.substr(0, dir.lastIndexOf('.'));
            var module_2 = require(filePath);
            for (var name_2 in module_2) {
                moduleExports = __spreadArray(__spreadArray([], moduleExports, true), [
                    {
                        relativePath: relativePath,
                        export: name_2,
                        value: module_2[name_2],
                    },
                ], false);
            }
        }
    }
    return moduleExports;
}
exports.getModuleExportsRecursive = getModuleExportsRecursive;
//# sourceMappingURL=moduleDiscoverer.js.map