"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encryptToken = exports.OBSOLETE_ITERATIONS = exports.DEFAULT_ITERATIONS = void 0;
var crypto_1 = require("crypto");
/**
 * Globally recommended value for token encryption iterations value.
 */
exports.DEFAULT_ITERATIONS = 10000;
/**
 * Old value for old tokens where was too much iterations and encrypting was too slow (not usable)
 * @deprecated Use DEFAULT_ITERATIONS value instead which is compromise in security of token and speed
 */
exports.OBSOLETE_ITERATIONS = 100000;
/**
 * Globally recommended function to encrypt tokens.
 * Use default iterations value if possible. Only for special cases or for obsolete tokens is used different.
 */
function encryptToken(plainToken, salt, iterations) {
    if (iterations === void 0) { iterations = exports.DEFAULT_ITERATIONS; }
    return new Promise(function (resolve, reject) {
        return (0, crypto_1.pbkdf2)(plainToken, salt, iterations, 512, 'sha512', function (error, key) {
            if (error) {
                reject(error);
            }
            else {
                resolve(key.toString('hex').substring(0, 64));
            }
        });
    });
}
exports.encryptToken = encryptToken;
//# sourceMappingURL=tokenEncryption.js.map