import * as Debug from 'debug';
export interface DebugConfig {
    /**
     * Globally changes logs to contain serialized arguments when logging method calls.
     * This is useful when running in Node.js environment where the logs are collected into a file.
     * In browser it's bad to serialize the arguments because browser allows to inspect the objects.
     */
    serialize: boolean;
    logDuration: boolean;
}
export declare const createDebugMethod: (localDebug: Debug.IDebugger) => (originalMethod: Function, that: any, label: string, args: any[]) => any;
/**
 * Add to a class method to debug it's calls
 *
 * For more information see https://www.npmjs.com/package/debug
 *
 * @param namespace Namespace of the debug logs. Run program with env variable DEBUG=<namespace> to enable the logs.
 */
export declare function debug(namespace: string, debugFactory?: Debug.IDebug): (_target: any, propertyKey: string, descriptor: PropertyDescriptor) => void;
export declare function getDebugConfig(): {
    serialize: boolean;
    logDuration: boolean;
};
export declare function setDebugConfig(newConfig: Partial<DebugConfig>): void;
